/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;

public class StreamRDFLimited
extends StreamRDFWrapper {
    private long count = 0L;
    private final long limit;

    public StreamRDFLimited(StreamRDF output, long limit) {
        super(output);
        this.limit = limit;
    }

    @Override
    public void triple(Triple triple) {
        ++this.count;
        if (this.count > this.limit) {
            throw new RiotException("Limit (" + this.limit + ") reached");
        }
        super.triple(triple);
    }

    @Override
    public void quad(Quad quad) {
        ++this.count;
        if (this.count > this.limit) {
            throw new RiotException("Limit (" + this.limit + ") reached");
        }
        super.quad(quad);
    }

    public long getCount() {
        return this.count;
    }

    public long getLimit() {
        return this.limit;
    }
}

