/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.OperationName;

public class Endpoint
implements Counters {
    public final OperationName opName;
    public final String endpointName;
    private final CounterSet counters = new CounterSet();

    public Endpoint(OperationName opName, String endpointName) {
        this.opName = opName;
        if (opName == null) {
            throw new InternalErrorException("opName is null");
        }
        this.endpointName = endpointName;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    @Override
    public CounterSet getCounters() {
        return this.counters;
    }

    public OperationName getOperationName() {
        return this.opName;
    }

    public boolean isType(OperationName operationName) {
        return this.opName.equals((Object)operationName);
    }

    public String getEndpoint() {
        return this.endpointName;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }
}

