/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import arq.cmd.CmdException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.Builder;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.build.Template;
import org.apache.jena.fuseki.build.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.ServerInitialConfig;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;

public class FusekiServer {
    public static final String runArea = "run";
    public static final String databasesLocationBase = "databases";
    public static final String backupDirNameBase = "backups";
    public static final String configDirNameBase = "configuration";
    public static final String logsNameBase = "logs";
    public static final String systemDatabaseNameBase = "system";
    public static final String systemFileAreaBase = "system_files";
    public static final String templatesNameBase = "templates";
    public static final String DFT_SHIRO_INI = "shiro.ini";
    public static final String DFT_CONFIG = "config.ttl";
    public static Path dirDatabases = null;
    public static Path dirBackups = null;
    public static Path dirConfiguration = null;
    public static Path dirLogs = null;
    public static Path dirSystemDatabase = null;
    public static Path dirFileArea = null;
    public static Path dirTemplates = null;
    private static boolean initialized = false;
    public static boolean serverInitialized = false;

    public static synchronized void reset() {
        initialized = false;
        initialized = false;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            FusekiEnv.setEnvironment();
            Path FUSEKI_HOME = FusekiEnv.FUSEKI_HOME;
            Path FUSEKI_BASE = FusekiEnv.FUSEKI_BASE;
            Fuseki.init();
            Fuseki.configLog.info("FUSEKI_HOME=" + (FUSEKI_HOME == null ? "unset" : FUSEKI_HOME.toString()));
            Fuseki.configLog.info("FUSEKI_BASE=" + FUSEKI_BASE.toString());
            if (FUSEKI_HOME != null) {
                if (!Files.isDirectory(FUSEKI_HOME, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_HOME is not a directory: " + FUSEKI_HOME);
                }
                if (!Files.isReadable(FUSEKI_HOME)) {
                    throw new FusekiConfigException("FUSEKI_HOME is not readable: " + FUSEKI_HOME);
                }
            }
            if (Files.exists(FUSEKI_BASE, new LinkOption[0])) {
                if (!Files.isDirectory(FUSEKI_BASE, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_BASE is not a directory: " + FUSEKI_BASE);
                }
                if (!Files.isWritable(FUSEKI_BASE)) {
                    throw new FusekiConfigException("FUSEKI_BASE is not writable: " + FUSEKI_BASE);
                }
            } else {
                FusekiServer.ensureDir(FUSEKI_BASE);
            }
            dirTemplates = FusekiServer.writeableDirectory(FUSEKI_BASE, templatesNameBase);
            dirDatabases = FusekiServer.writeableDirectory(FUSEKI_BASE, databasesLocationBase);
            dirBackups = FusekiServer.writeableDirectory(FUSEKI_BASE, backupDirNameBase);
            dirConfiguration = FusekiServer.writeableDirectory(FUSEKI_BASE, configDirNameBase);
            dirLogs = FusekiServer.writeableDirectory(FUSEKI_BASE, logsNameBase);
            dirSystemDatabase = FusekiServer.writeableDirectory(FUSEKI_BASE, systemDatabaseNameBase);
            dirFileArea = FusekiServer.writeableDirectory(FUSEKI_BASE, systemFileAreaBase);
            if (Files.isRegularFile(FUSEKI_BASE, new LinkOption[0])) {
                throw new FusekiConfigException("FUSEKI_BASE exists but is a file");
            }
            FusekiServer.copyFileIfMissing(null, DFT_SHIRO_INI, FUSEKI_BASE);
            FusekiServer.copyFileIfMissing(null, DFT_CONFIG, FUSEKI_BASE);
            for (String n : Template.templateNames) {
                FusekiServer.copyFileIfMissing(null, n, FUSEKI_BASE);
            }
            serverInitialized = true;
        }
        catch (RuntimeException ex) {
            Fuseki.serverLog.error("Exception in server initialization", ex);
            throw ex;
        }
    }

    private static boolean emptyDir(Path dir) {
        return dir.toFile().list().length <= 2;
    }

    private static void copyFileIfMissing(Path src, String fn, Path dst) {
        Path dstFile = dst.resolve(fn);
        if (Files.exists(dstFile, new LinkOption[0])) {
            return;
        }
        if (src != null) {
            try {
                Files.copy(src.resolve(fn), dstFile, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e2) {
                IO.exception("Failed to copy file " + src, e2);
                e2.printStackTrace();
            }
        } else {
            try {
                InputStream in = FusekiServer.class.getResource(fn).openStream();
                Files.copy(in, dstFile, new CopyOption[0]);
            }
            catch (IOException e3) {
                IO.exception("Failed to copy file from resource: " + src, e3);
                e3.printStackTrace();
            }
        }
    }

    public static void initializeDataAccessPoints(ServerInitialConfig initialSetup, String configDir) {
        List<DataAccessPoint> configFileDBs = FusekiServer.initServerConfiguration(initialSetup);
        List<DataAccessPoint> directoryDBs = FusekiConfig.readConfigurationDirectory(configDir);
        List<DataAccessPoint> systemDBs = FusekiConfig.readSystemDatabase(SystemState.getDataset());
        ArrayList<DataAccessPoint> datapoints = new ArrayList<DataAccessPoint>();
        datapoints.addAll(configFileDBs);
        datapoints.addAll(directoryDBs);
        datapoints.addAll(systemDBs);
        FusekiServer.enable(datapoints);
    }

    private static void enable(List<DataAccessPoint> datapoints) {
        for (DataAccessPoint dap : datapoints) {
            Fuseki.configLog.info("Register: " + dap.getName());
            DataAccessPointRegistry.register(dap.getName(), dap);
        }
    }

    private static List<DataAccessPoint> initServerConfiguration(ServerInitialConfig params) {
        List<DataAccessPoint> datasets = DS.list();
        if (params == null) {
            return datasets;
        }
        if (params.fusekiConfigFile != null) {
            if (FileOps.exists(params.fusekiConfigFile)) {
                Fuseki.configLog.info("Configuration file: " + params.fusekiConfigFile);
                List<DataAccessPoint> cmdLineDatasets = FusekiConfig.readConfigFile(params.fusekiConfigFile);
                datasets.addAll(cmdLineDatasets);
            } else {
                Fuseki.configLog.info("Configuration file '" + params.fusekiConfigFile + "' does not exist");
            }
        } else if (params.dsg != null) {
            DataAccessPoint dap = FusekiServer.defaultConfiguration(params.datasetPath, params.dsg, params.allowUpdate);
            datasets.add(dap);
        } else if (params.templateFile != null) {
            Fuseki.configLog.info("Template file: " + params.templateFile);
            String dir = params.params.get("DIR");
            if (dir != null) {
                if (Lib.equal(dir, "--mem--")) {
                    Fuseki.configLog.info("TDB dataset: in-memory");
                } else {
                    if (!FileOps.exists(dir)) {
                        throw new CmdException("Directory not found: " + dir);
                    }
                    Fuseki.configLog.info("TDB dataset: directory=" + dir);
                }
            }
            DataAccessPoint dap = FusekiServer.configFromTemplate(params.templateFile, params.datasetPath, params.params);
            datasets.add(dap);
        }
        return datasets;
    }

    private static DataAccessPoint configFromTemplate(String templateFile, String datasetPath, Map<String, String> params) {
        datasetPath = DataAccessPoint.canonical(datasetPath);
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("NAME", datasetPath);
        } else if (!params.containsKey("NAME")) {
            Fuseki.configLog.warn("No NAME found in template parameters (added)");
            params.put("NAME", datasetPath);
        }
        FusekiServer.addGlobals(params);
        String str2 = TemplateFunctions.templateFile(templateFile, params, Lang.TTL);
        Lang lang = RDFLanguages.filenameToLang(str2, Lang.TTL);
        StringReader sr = new StringReader(str2);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read(model, sr, datasetPath, lang);
        Statement stmt = FusekiServer.getOne(model, null, FusekiVocab.pServiceName, null);
        if (stmt == null) {
            StmtIterator sIter = model.listStatements(null, FusekiVocab.pServiceName, (RDFNode)null);
            if (!sIter.hasNext()) {
                ServletOps.errorBadRequest("No name given in description of Fuseki service");
            }
            sIter.next();
            if (sIter.hasNext()) {
                ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
            }
            throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
        }
        Resource subject = stmt.getSubject();
        DataAccessPoint dap = Builder.buildDataAccessPoint(subject);
        return dap;
    }

    public static void addGlobals(Map<String, String> params) {
        if (params == null) {
            Fuseki.configLog.warn("FusekiServer.addGlobals : params is null", new Throwable());
            return;
        }
        if (!params.containsKey("FUSEKI_BASE")) {
            params.put("FUSEKI_BASE", FusekiServer.pathStringOrElse(FusekiEnv.FUSEKI_BASE, "unset"));
        }
        if (!params.containsKey("FUSEKI_HOME")) {
            params.put("FUSEKI_HOME", FusekiServer.pathStringOrElse(FusekiEnv.FUSEKI_HOME, "unset"));
        }
    }

    private static String pathStringOrElse(Path path, String dft) {
        if (path == null) {
            return dft;
        }
        return path.toString();
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static DataAccessPoint defaultConfiguration(String name, DatasetGraph dsg, boolean updatable) {
        name = DataAccessPoint.canonical(name);
        DataAccessPoint dap = new DataAccessPoint(name);
        DataService ds = Builder.buildDataService(dsg, updatable);
        dap.setDataService(ds);
        return dap;
    }

    private static void ensureDir(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new FusekiConfigException("Failed to create directory: " + directory);
            }
        } else if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + directory);
        }
    }

    private static void mustExist(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            throw new FusekiConfigException("Does not exist: " + directory);
        }
        if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + directory);
        }
    }

    private static boolean exists(Path directory) {
        File dir = directory.toFile();
        return dir.exists();
    }

    private static Path writeableDirectory(Path root, String relName) {
        Path p = FusekiServer.makePath(root, relName);
        FusekiServer.ensureDir(p);
        if (!Files.isWritable(p)) {
            throw new FusekiConfigException("Not writable: " + p);
        }
        return p;
    }

    private static Path makePath(Path root, String relName) {
        Path path = root.resolve(relName);
        return path;
    }
}

