/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;

public abstract class ActionBase
extends ServletBase {
    protected final Logger log;

    protected ActionBase(Logger log) {
        this.log = log;
    }

    @Override
    public void init() {
    }

    protected void doCommon(HttpServletRequest request, HttpServletResponse response) {
        try {
            long id = ActionBase.allocRequestId(request, response);
            HttpAction action = this.allocHttpAction(id, request, response);
            this.printRequest(action);
            action.setStartTime();
            response = action.response;
            this.initResponse(request, response);
            Context cxt = ARQ.getContext();
            try {
                this.execCommonWorker(action);
            }
            catch (QueryCancelledException ex) {
                String message = String.format("The query timed out (restricted to %s ms)", cxt.get(ARQ.queryTimeout));
                ServletOps.responseSendError(response, 503, message);
            }
            catch (ActionErrorException ex) {
                if (ex.exception != null) {
                    ex.exception.printStackTrace(System.err);
                }
                if (ex.message != null) {
                    ServletOps.responseSendError(response, ex.rc, ex.message);
                } else {
                    ServletOps.responseSendError(response, ex.rc);
                }
            }
            catch (RuntimeIOException ex) {
                this.log.warn(String.format("[%d] Runtime IO Exception (client left?) RC = %d : %s", id, 500, ex.getMessage()), ex);
                ServletOps.responseSendError(response, 500, ex.getMessage());
            }
            catch (Throwable ex) {
                this.log.warn(String.format("[%d] RC = %d : %s", id, 500, ex.getMessage()), ex);
                ServletOps.responseSendError(response, 500, ex.getMessage());
            }
            action.setFinishTime();
            this.printResponse(action);
            this.archiveHttpAction(action);
        }
        catch (Throwable th) {
            this.log.error("Internal error", th);
        }
    }

    protected HttpAction allocHttpAction(long id, HttpServletRequest request, HttpServletResponse response) {
        return new HttpAction(id, this.log, request, response, Fuseki.verboseLogging);
    }

    protected final void startRequest(HttpAction action) {
        action.startRequest();
    }

    protected final void finishRequest(HttpAction action) {
        action.finishRequest();
    }

    private void archiveHttpAction(HttpAction action) {
        action.minimize();
    }

    protected abstract void execCommonWorker(HttpAction var1);

    protected static String extractItemName(HttpAction action) {
        String x1 = action.request.getServletPath();
        String x2 = action.request.getPathInfo();
        String pathInfo = action.request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            return null;
        }
        String name = pathInfo;
        int idx = pathInfo.lastIndexOf(47);
        if (idx > 0) {
            name = name.substring(idx);
        }
        return name;
    }

    protected void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405, "HTTP PATCH not supported");
    }

    private void printRequest(HttpAction action) {
        String url = ActionLib.wholeRequestURL(action.request);
        String method = action.request.getMethod();
        this.log.info(String.format("[%d] %s %s", action.id, method, url));
        if (action.verbose) {
            Enumeration<String> en = action.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = en.nextElement();
                Enumeration<String> vals = action.request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    this.log.info(String.format("[%d]   ", action.id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    this.log.info(String.format("[%d]   %-20s %s", action.id, h, vals.nextElement()));
                }
            }
        }
    }

    private void initResponse(HttpServletRequest request, HttpServletResponse response) {
        ActionBase.setCommonHeaders(response);
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            ActionBase.setVaryHeader(response);
        }
    }

    private void printResponse(HttpAction action) {
        long time = action.getTime();
        HttpServletResponseTracker response = action.response;
        if (action.verbose) {
            if (action.contentType != null) {
                this.log.info(String.format("[%d]   %-20s %s", action.id, "Content-Type", action.contentType));
            }
            if (action.contentLength != -1) {
                this.log.info(String.format("[%d]   %-20s %d", action.id, "Content-Length", action.contentLength));
            }
            for (Map.Entry<String, String> e2 : action.headers.entrySet()) {
                this.log.info(String.format("[%d]   %-20s %s", action.id, e2.getKey(), e2.getValue()));
            }
        }
        String timeStr = ActionBase.fmtMillis(time);
        if (action.message == null) {
            this.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, HttpSC.getMessage(action.statusCode), timeStr));
        } else {
            this.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, action.message, timeStr));
        }
    }

    private static String fmtMillis(long time) {
        if (time < 1000L) {
            return String.format("%,d ms", time);
        }
        return String.format("%,.3f s", (double)time / 1000.0);
    }
}

