/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.QueryCancelledException;
import java.io.InputStream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.servlets.ActionBase;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;

public abstract class ActionSPARQL
extends ActionBase {
    protected ActionSPARQL() {
        super(Fuseki.actionLog);
    }

    protected abstract void validate(HttpAction var1);

    protected abstract void perform(HttpAction var1);

    @Override
    protected void execCommonWorker(HttpAction action) {
        DataService dSrv;
        DataAccessPoint dataAccessPoint;
        String datasetUri = this.mapRequestToDataset(action);
        if (datasetUri != null) {
            dataAccessPoint = (DataAccessPoint)DataAccessPointRegistry.get().get(datasetUri);
            if (dataAccessPoint == null) {
                ServletOps.errorNotFound("No dataset for URI: " + datasetUri);
                return;
            }
            dSrv = dataAccessPoint.getDataService();
            if (!dSrv.isAcceptingRequests()) {
                ServletOps.errorNotFound("Dataset not active: " + datasetUri);
                return;
            }
        } else {
            dataAccessPoint = null;
            dSrv = DataService.serviceOnlyDataService();
        }
        String operationName = this.mapRequestToOperation(action, dataAccessPoint);
        action.setRequest(dataAccessPoint, dSrv);
        Endpoint op = dSrv.getOperation(operationName);
        action.setEndpoint(op, operationName);
        this.executeAction(action);
    }

    protected void executeAction(HttpAction action) {
        this.executeLifecycle(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeLifecycle(HttpAction action) {
        this.startRequest(action);
        CounterSet csService = action.getDataService().getCounters();
        CounterSet csOperation = action.getEndpoint().getCounters();
        ActionSPARQL.incCounter(csService, CounterName.Requests);
        ActionSPARQL.incCounter(csOperation, CounterName.Requests);
        try {
            try {
                this.validate(action);
            }
            catch (ActionErrorException ex) {
                ActionSPARQL.incCounter(csOperation, CounterName.RequestsBad);
                ActionSPARQL.incCounter(csService, CounterName.RequestsBad);
                throw ex;
            }
            try {
                this.perform(action);
                ActionSPARQL.incCounter(csOperation, CounterName.RequestsGood);
                ActionSPARQL.incCounter(csService, CounterName.RequestsGood);
            }
            catch (QueryCancelledException | RuntimeIOException | ActionErrorException ex) {
                ActionSPARQL.incCounter(csOperation, CounterName.RequestsBad);
                ActionSPARQL.incCounter(csService, CounterName.RequestsBad);
                throw ex;
            }
        }
        finally {
            this.finishRequest(action);
        }
    }

    protected String mapRequestToDataset(HttpAction action) {
        return ActionLib.mapRequestToDataset(action);
    }

    protected String mapRequestToOperation(HttpAction action, DataAccessPoint dataAccessPoint) {
        return ActionLib.mapRequestToOperation(action, dataAccessPoint);
    }

    protected static void incCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionSPARQL.incCounter(counters.getCounters(), name);
    }

    protected static void decCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionSPARQL.decCounter(counters.getCounters(), name);
    }

    protected static void incCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.inc(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter inc", ex);
        }
    }

    protected static void decCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.dec(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter dec", ex);
        }
    }

    public static void parse(HttpAction action, StreamRDF dest, InputStream input, Lang lang, String base) {
        try {
            ReaderRIOT r = RDFDataMgr.createReader(lang);
            if (r == null) {
                ServletOps.errorBadRequest("No parser for language '" + lang.getName() + "'");
            }
            ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(action.log);
            r.setErrorHandler(errorHandler);
            r.read(input, base, null, dest, null);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest("Parse error: " + ex.getMessage());
        }
    }
}

