/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.servlets.HttpAction;

public class HttpServletResponseTracker
extends HttpServletResponseWrapper {
    private final HttpAction action;

    public HttpServletResponseTracker(HttpAction action, HttpServletResponse response) {
        super(response);
        this.action = action;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.action.statusCode = sc;
        this.action.message = msg;
        super.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.action.statusCode = sc;
        this.action.message = null;
        super.sendError(sc);
    }

    @Override
    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.action.headers.put(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        Log.warn(this, "Unexpected addHeader - not recorded in log");
        super.addHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        this.action.statusCode = sc;
        this.action.message = null;
        super.setStatus(sc);
    }

    @Override
    @Deprecated
    public void setStatus(int sc, String sm) {
        this.action.statusCode = sc;
        this.action.message = sm;
        super.setStatus(sc, sm);
    }

    @Override
    public void setContentLength(int len) {
        this.action.contentLength = len;
        super.setContentLength(len);
    }

    @Override
    public void setContentType(String type) {
        this.action.contentType = type;
        super.setContentType(type);
    }
}

