/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.Prologue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResultSet {
    private static Logger xlog = LoggerFactory.getLogger(ResponseResultSet.class);
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputSPARQL = "sparql";
    private static final String contentOutputText = "text";
    private static final String contentOutputCSV = "csv";
    private static final String contentOutputTSV = "tsv";
    private static final String contentOutputThrift = "thrift";
    public static Map<String, String> shortNamesResultSet = new HashMap<String, String>();

    public static void doResponseResultSet(HttpAction action, Boolean booleanResult) {
        ResponseResultSet.doResponseResultSet$(action, null, booleanResult, null, DEF.rsOfferBoolean);
    }

    public static void doResponseResultSet(HttpAction action, ResultSet resultSet, Prologue qPrologue) {
        ResponseResultSet.doResponseResultSet$(action, resultSet, null, qPrologue, DEF.rsOfferTable);
    }

    private static void doResponseResultSet$(HttpAction action, ResultSet resultSet, Boolean booleanResult, Prologue qPrologue, AcceptList contentTypeOffer) {
        String forceAccept;
        String outputField;
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        long id = action.id;
        if (resultSet == null && booleanResult == null) {
            xlog.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            xlog.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, contentTypeOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesResultSet)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        String stylesheetURL = ResponseOps.paramStylesheet(request);
        if (stylesheetURL != null && Lib.equal(serializationType, "application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseOps.paramForceAccept(request)) != null) {
            contentType = "text/plain";
        }
        if (Lib.equal(serializationType, "application/sparql-results+xml")) {
            ResponseResultSet.sparqlXMLOutput(action, contentType, resultSet, stylesheetURL, booleanResult);
        } else if (Lib.equal(serializationType, "application/sparql-results+json")) {
            ResponseResultSet.jsonOutput(action, contentType, resultSet, booleanResult);
        } else if (Lib.equal(serializationType, "text/plain")) {
            ResponseResultSet.textOutput(action, contentType, resultSet, qPrologue, booleanResult);
        } else if (Lib.equal(serializationType, "text/csv")) {
            ResponseResultSet.csvOutput(action, contentType, resultSet, booleanResult);
        } else if (Lib.equal(serializationType, "text/tab-separated-values")) {
            ResponseResultSet.tsvOutput(action, contentType, resultSet, booleanResult);
        } else if (Lib.equal(serializationType, "application/sparql-results+thrift")) {
            ResponseResultSet.thriftOutput(action, contentType, resultSet, booleanResult);
        } else {
            ServletOps.errorBadRequest("Can't determine output serialization: " + serializationType);
        }
    }

    public static void setHttpResponse(HttpAction action, String contentType, String charset) {
        ServletOps.setNoCache(action);
        if (contentType != null) {
            if (charset != null && !ResponseResultSet.isXML(contentType)) {
                contentType = contentType + "; charset=" + charset;
            }
            action.log.trace("Content-Type for response: " + contentType);
            action.response.setContentType(contentType);
        }
    }

    private static boolean isXML(String contentType) {
        return contentType.equals("application/rdf+xml") || contentType.equals("application/sparql-results+xml") || contentType.equals("application/xml");
    }

    private static void sparqlXMLOutput(HttpAction action, String contentType, final ResultSet resultSet, final String stylesheetURL, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetFormatter.outputAsXML((OutputStream)out, resultSet, stylesheetURL);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.outputAsXML((OutputStream)out, booleanResult, stylesheetURL);
                }
            }
        };
        ResponseResultSet.output(action, contentType, null, proc);
    }

    private static void jsonOutput(HttpAction action, String contentType, final ResultSet resultSet, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetFormatter.outputAsJSON((OutputStream)out, resultSet);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.outputAsJSON((OutputStream)out, booleanResult);
                }
            }
        };
        try {
            String callback = ResponseOps.paramCallback(action.request);
            ServletOutputStream out = action.response.getOutputStream();
            if (callback != null) {
                callback = callback.replace("\r", "");
                callback = callback.replace("\n", "");
                out.print(callback);
                out.println("(");
            }
            ResponseResultSet.output(action, contentType, "utf-8", proc);
            if (callback != null) {
                out.println(")");
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private static void textOutput(HttpAction action, String contentType, final ResultSet resultSet, final Prologue qPrologue, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetFormatter.out((OutputStream)out, resultSet, qPrologue);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.out((OutputStream)out, booleanResult);
                }
            }
        };
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    private static void csvOutput(HttpAction action, String contentType, final ResultSet resultSet, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetFormatter.outputAsCSV((OutputStream)out, resultSet);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.outputAsCSV((OutputStream)out, booleanResult);
                }
            }
        };
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    private static void tsvOutput(HttpAction action, String contentType, final ResultSet resultSet, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetFormatter.outputAsTSV((OutputStream)out, resultSet);
                }
                if (booleanResult != null) {
                    ResultSetFormatter.outputAsTSV((OutputStream)out, booleanResult);
                }
            }
        };
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    private static void thriftOutput(HttpAction action, String contentType, final ResultSet resultSet, final Boolean booleanResult) {
        OutputContent proc = new OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (resultSet != null) {
                    ResultSetMgr.write((OutputStream)out, resultSet, ResultSetLang.SPARQLResultSetThrift);
                }
                if (booleanResult != null) {
                    xlog.error("Can't write boolen result in thrift");
                }
            }
        };
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    private static void output(HttpAction action, String contentType, String charset, OutputContent proc) {
        try {
            ResponseResultSet.setHttpResponse(action, contentType, charset);
            action.response.setStatus(200);
            ServletOutputStream out = action.response.getOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                action.log.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                out.println();
                out.println("##  Query cancelled due to timeout during execution   ##");
                out.println("##  ****          Incomplete results           ****   ##");
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    static {
        ResponseOps.put(shortNamesResultSet, contentOutputJSON, "application/sparql-results+json");
        ResponseOps.put(shortNamesResultSet, contentOutputSPARQL, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputXML, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputText, "text/plain");
        ResponseOps.put(shortNamesResultSet, contentOutputCSV, "text/csv");
        ResponseOps.put(shortNamesResultSet, contentOutputTSV, "text/tab-separated-values");
        ResponseOps.put(shortNamesResultSet, contentOutputThrift, "application/sparql-results+thrift");
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1);
    }
}

