/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.OperationName;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionSPARQL;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.REST_Quads_R;
import org.apache.jena.fuseki.servlets.REST_Quads_RW;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_R;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_RW;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class SPARQL_UberServlet
extends ActionSPARQL {
    private final ActionSPARQL queryServlet = new SPARQL_QueryDataset();
    private final ActionSPARQL updateServlet = new SPARQL_Update();
    private final ActionSPARQL uploadServlet = new SPARQL_Upload();
    private final ActionSPARQL gspServlet_R = new SPARQL_GSP_R();
    private final ActionSPARQL gspServlet_RW = new SPARQL_GSP_RW();
    private final ActionSPARQL restQuads_R = new REST_Quads_R();
    private final ActionSPARQL restQuads_RW = new REST_Quads_RW();

    protected abstract boolean allowQuery(HttpAction var1);

    protected abstract boolean allowUpdate(HttpAction var1);

    protected abstract boolean allowREST_R(HttpAction var1);

    protected abstract boolean allowREST_W(HttpAction var1);

    protected abstract boolean allowQuadsR(HttpAction var1);

    protected abstract boolean allowQuadsW(HttpAction var1);

    private String getEPName(String dsname, List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        String x = endpoints.get(0);
        x = !dsname.endsWith("/") ? dsname + "/" + x : dsname + x;
        return x;
    }

    @Override
    protected void validate(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.validate");
    }

    @Override
    protected void perform(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.perform");
    }

    @Override
    protected String mapRequestToDataset(HttpAction action) {
        String uri = ActionLib.removeContextPath(action);
        return ActionLib.mapRequestToDatasetLongest$(uri);
    }

    @Override
    protected void executeAction(HttpAction action) {
        boolean hasTrailing;
        long id = action.id;
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        String actionURI = action.getActionURI();
        String method = request.getMethod();
        DataAccessPoint desc = action.getDataAccessPoint();
        DataService dSrv = action.getDataService();
        String trailing = this.findTrailing(actionURI, desc.getName());
        String qs = request.getQueryString();
        boolean hasParams = request.getParameterMap().size() > 0;
        boolean hasParamQuery = request.getParameter("query") != null;
        boolean hasParamUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean hasParamGraphDefault = request.getParameter("default") != null;
        String ct = request.getContentType();
        String charset = request.getCharacterEncoding();
        MediaType mt = null;
        if (ct != null) {
            mt = MediaType.create(ct, charset);
        }
        if (action.log.isInfoEnabled()) {
            action.log.info(String.format("[%d] %s %s :: '%s' :: %s ? %s", id, method, desc.getName(), trailing, mt == null ? "<none>" : mt, qs == null ? "" : qs));
        }
        boolean bl = hasTrailing = trailing.length() != 0;
        if (!hasTrailing && !hasParams) {
            this.restQuads_RW.executeLifecycle(action);
            return;
        }
        if (!hasTrailing) {
            boolean isPOST = action.getRequest().getMethod().equals("POST");
            if (hasParamQuery || isPOST && "application/sparql-query".equalsIgnoreCase(ct)) {
                if (!this.allowQuery(action)) {
                    ServletOps.errorForbidden("Forbidden: SPARQL query");
                }
                this.executeRequest(action, this.queryServlet);
                return;
            }
            if (isPOST && (hasParamUpdate || "application/sparql-update".equalsIgnoreCase(ct))) {
                if (!this.allowUpdate(action)) {
                    ServletOps.errorForbidden("Forbidden: SPARQL update");
                }
                this.executeRequest(action, this.updateServlet);
                return;
            }
            if (hasParamGraph || hasParamGraphDefault) {
                this.doGraphStoreProtocol(action);
                return;
            }
            ServletOps.errorBadRequest("Malformed request");
            ServletOps.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Read operation : " + method);
        }
        boolean checkForPossibleService = true;
        if (action.getEndpoint() != null) {
            if (this.serviceDispatch(action, OperationName.Query, this.queryServlet)) {
                return;
            }
            if (this.serviceDispatch(action, OperationName.Update, this.updateServlet)) {
                return;
            }
            if (this.serviceDispatch(action, OperationName.Upload, this.uploadServlet)) {
                return;
            }
            if (hasParams) {
                if (this.serviceDispatch(action, OperationName.GSP_R, this.gspServlet_R)) {
                    return;
                }
                if (this.serviceDispatch(action, OperationName.GSP, this.gspServlet_RW)) {
                    return;
                }
            } else {
                if (this.serviceDispatch(action, OperationName.GSP_R, this.restQuads_R)) {
                    return;
                }
                if (this.serviceDispatch(action, OperationName.GSP, this.restQuads_RW)) {
                    return;
                }
            }
        }
        if (hasParams) {
            ServletOps.errorNotFound("Not found: dataset='" + this.printName(desc.getName()) + "' service='" + this.printName(trailing) + "'");
        }
        this.doGraphStoreProtocol(action);
    }

    private String printName(String x) {
        if (x.startsWith("/")) {
            return x.substring(1);
        }
        return x;
    }

    private void doGraphStoreProtocol(HttpAction action) {
        Endpoint operation = action.getEndpoint();
        String method = action.request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            if (this.allowREST_R(action)) {
                ServletOps.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Read operation : " + method);
            }
            this.executeRequest(action, this.gspServlet_R);
            return;
        }
        if (!this.allowREST_W(action)) {
            ServletOps.errorForbidden("Forbidden: SPARQL Graph Store Protocol : " + method);
        }
        this.executeRequest(action, this.gspServlet_RW);
    }

    private void executeRequest(HttpAction action, ActionSPARQL servlet) {
        servlet.executeLifecycle(action);
    }

    protected static MediaType contentNegotationQuads(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    private boolean serviceDispatch(HttpAction action, OperationName opName, ActionSPARQL servlet) {
        Endpoint operation = action.getEndpoint();
        if (operation == null) {
            return false;
        }
        if (!operation.isType(opName)) {
            return false;
        }
        servlet.executeLifecycle(action);
        return true;
    }

    protected String findTrailing(String uri, String dsname) {
        if (dsname.length() >= uri.length()) {
            return "";
        }
        return uri.substring(dsname.length() + 1);
    }

    @Override
    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    public static class AccessByConfig
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return this.isEnabled(action, OperationName.Query);
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return this.isEnabled(action, OperationName.Update);
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return this.isEnabled(action, OperationName.GSP_R) || this.isEnabled(action, OperationName.GSP);
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return this.isEnabled(action, OperationName.GSP);
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return this.isEnabled(action, OperationName.GSP_R);
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return this.isEnabled(action, OperationName.GSP);
        }

        private boolean isEnabled(HttpAction action, OperationName opName) {
            DataService dSrv = action.getDataService();
            if (dSrv == null) {
                return false;
            }
            return !dSrv.getOperation(opName).isEmpty();
        }
    }

    public static class ReadWrite
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return true;
        }
    }

    public static class ReadOnly
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return false;
        }
    }
}

