/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.ValidationAction;
import org.apache.jena.fuseki.validation.ValidatorBaseJson;

public class QueryValidator
extends ValidatorBaseJson {
    static final String paramQuery = "query";
    static final String paramSyntax = "languageSyntax";
    static final String jInput = "input";
    static final String jFormatted = "formatted";
    static final String jAlgebra = "algebra";
    static final String jAlgebraQuads = "algebra-quads";
    static final String jAlgebraOpt = "algebra-opt";
    static final String jAlgebraOptQuads = "algebra-opt-quads";

    @Override
    protected String validatorName() {
        return "SPARQL Query";
    }

    @Override
    protected JsonObject execute(ValidationAction action) {
        Syntax language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String queryString = QueryValidator.getArg(action, paramQuery);
        String querySyntax = QueryValidator.getArgOrNull(action, paramSyntax);
        if (querySyntax == null || querySyntax.equals("")) {
            querySyntax = "SPARQL";
        }
        if ((language = Syntax.lookup(querySyntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + querySyntax);
            return null;
        }
        boolean outputSPARQL = true;
        boolean outputAlgebra = true;
        boolean outputQuads = true;
        boolean outputOptimized = true;
        boolean outputOptimizedQuads = true;
        obj.key(jInput).value(queryString);
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, "http://example/base/", language);
        }
        catch (QueryParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value(ex.getLine());
            obj.key("parse-error-column").value(ex.getColumn());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        if (query2 != null) {
            if (outputSPARQL) {
                this.formatted(obj, query2);
            }
            if (outputAlgebra) {
                this.algebra(obj, query2);
            }
            if (outputQuads) {
                this.algebraQuads(obj, query2);
            }
            if (outputOptimized) {
                this.algebraOpt(obj, query2);
            }
            if (outputOptimizedQuads) {
                this.algebraOptQuads(obj, query2);
            }
        }
        obj.finishObject();
        return obj.build().getAsObject();
    }

    private void formatted(JsonBuilder obj, Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        query2.serialize(out);
        obj.key(jFormatted).value(out.asString());
    }

    private void algebra(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        obj.key(jAlgebra).value(this.string(query2, op));
    }

    private void algebraQuads(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.toQuadForm(op);
        obj.key(jAlgebraQuads).value(this.string(query2, op));
    }

    private void algebraOpt(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.optimize(op);
        obj.key(jAlgebraOpt).value(this.string(query2, op));
    }

    private void algebraOptQuads(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.toQuadForm(op);
        op = Algebra.optimize(op);
        obj.key(jAlgebraOptQuads).value(this.string(query2, op));
    }

    private String string(Query query2, Op op) {
        SerializationContext sCxt = new SerializationContext(query2);
        IndentedLineBuffer out = new IndentedLineBuffer();
        op.output(out, sCxt);
        return out.asString();
    }
}

