/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.query.spatial.DatasetGraphSpatial;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialDocProducerTriples;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexLucene;
import org.apache.jena.query.spatial.SpatialIndexSolr;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.assembler.SpatialVocab;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrServer;

public class SpatialDatasetFactory {
    public static Dataset create(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, SpatialVocab.spatialDataset);
    }

    public static Dataset create(Dataset base, SpatialIndex textIndex) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = SpatialDatasetFactory.create(dsg, textIndex);
        return DatasetFactory.create(dsg);
    }

    public static DatasetGraph create(DatasetGraph dsg, SpatialIndex spatialIndex) {
        SpatialDocProducerTriples producer = new SpatialDocProducerTriples(spatialIndex);
        DatasetGraphSpatial dsgt = new DatasetGraphSpatial(dsg, spatialIndex, producer);
        Context c = dsgt.getContext();
        dsgt.getContext().set(SpatialQuery.spatialIndex, spatialIndex);
        return dsgt;
    }

    public static SpatialIndex createLuceneIndex(Directory directory, EntityDefinition entMap) {
        SpatialIndexLucene index = new SpatialIndexLucene(directory, entMap);
        return index;
    }

    public static Dataset createLucene(Dataset base, Directory directory, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createLuceneIndex(directory, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createLuceneIndex(directory, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    public static SpatialIndex createSolrIndex(SolrServer server, EntityDefinition entMap) {
        SpatialIndexSolr index = new SpatialIndexSolr(server, entMap);
        return index;
    }

    public static Dataset createSolrIndex(Dataset base, SolrServer server, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createSolrIndex(server, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    public static DatasetGraph createSolrIndex(DatasetGraph base, SolrServer server, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createSolrIndex(server, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    static {
        SpatialQuery.init();
    }
}

