/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import org.apache.jena.query.spatial.SpatialPredicatePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialPredicatePairValue {
    private static Logger log = LoggerFactory.getLogger(SpatialPredicatePairValue.class);
    private SpatialPredicatePair pair;
    private Double latitudeValue;
    private Double longitudeValue;

    public SpatialPredicatePairValue(SpatialPredicatePair pair) {
        this.pair = pair;
    }

    public Double getLatitudeValue() {
        return this.latitudeValue;
    }

    public Double getLongitudeValue() {
        return this.longitudeValue;
    }

    public SpatialPredicatePair getPair() {
        return this.pair;
    }

    public void setValue(Node predicate, Double value) {
        if (predicate.equals(this.pair.getLatitudePredicate())) {
            this.latitudeValue = value;
        } else if (predicate.equals(this.pair.getLongitudePredicate())) {
            this.longitudeValue = value;
        } else {
            log.warn("Try to set value to a SpatialPredicatePairValue with no such predicate: " + predicate + " :: " + value);
        }
    }

    public Double getTheOtherValue(Node predicate) {
        if (this.pair.getLatitudePredicate().equals(predicate)) {
            return this.getLongitudeValue();
        }
        if (predicate.equals(this.pair.getLongitudePredicate())) {
            return this.getLatitudeValue();
        }
        log.warn("Try to get value to a SpatialPredicatePairValue with no such predicate: " + predicate);
        return null;
    }

    public int hashCode() {
        int latitudeHashCode = this.latitudeValue == null ? 0 : this.latitudeValue.hashCode() * 17;
        int longitudeHashCode = this.longitudeValue == null ? 0 : this.longitudeValue.hashCode() * 19;
        return this.pair.hashCode() * 11 + latitudeHashCode + longitudeHashCode;
    }

    public boolean equals(Object otherObject) {
        boolean latitudeValueEquals;
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        SpatialPredicatePairValue other = (SpatialPredicatePairValue)otherObject;
        boolean bl = this.latitudeValue == null ? other.latitudeValue == null : (latitudeValueEquals = this.latitudeValue.equals(other.latitudeValue));
        boolean longitudeValueEquals = this.longitudeValue == null ? other.longitudeValue == null : this.longitudeValue.equals(other.longitudeValue);
        return this.pair.equals(other.pair) && latitudeValueEquals && longitudeValueEquals;
    }
}

