/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDB;
import com.spatial4j.core.context.SpatialContext;
import org.apache.jena.query.spatial.assembler.SpatialAssembler;
import org.apache.jena.query.spatial.pfunction.library.EastPF;
import org.apache.jena.query.spatial.pfunction.library.IntersectsBoxPF;
import org.apache.jena.query.spatial.pfunction.library.IsNearByPF;
import org.apache.jena.query.spatial.pfunction.library.IsWithinBoxPF;
import org.apache.jena.query.spatial.pfunction.library.IsWithinCirclePF;
import org.apache.jena.query.spatial.pfunction.library.NorthPF;
import org.apache.jena.query.spatial.pfunction.library.SouthPF;
import org.apache.jena.query.spatial.pfunction.library.WestPF;

public class SpatialQuery {
    private static boolean initialized = false;
    private static Object lock = new Object();
    public static String NS = "http://jena.apache.org/spatial#";
    public static String IRI = "http://jena.apache.org/#spatial";
    public static final Symbol spatialIndex = Symbol.create(NS + "index");
    public static final String PATH = "org.apache.jena.query.spatial";
    private static String metadataLocation = "org/apache/jena/query/spatial/properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ Spatial Query";
    public static final String VERSION = metadata.get("org.apache.jena.query.spatial.version", "unknown");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.query.spatial.build.datetime", "unset");
    public static SpatialContext ctx = SpatialContext.GEO;
    public static final String JTS_SPATIAL_CONTEXT_FACTORY_CLASS = "com.spatial4j.core.context.jts.JtsSpatialContextFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            TDB.init();
            SpatialAssembler.init();
            SystemInfo sysInfo = new SystemInfo(IRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem(sysInfo);
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#withinCircle", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsWithinCirclePF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#nearby", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsNearByPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#withinBox", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsWithinBoxPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#intersectBox", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IntersectsBoxPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#north", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new NorthPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#south", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new SouthPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#east", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new EastPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#west", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new WestPF();
                }
            });
        }
    }

    static {
        SpatialQuery.init();
    }
}

