/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextDocProducerTriples;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.TextIndexSolr;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrServer;

public class TextDatasetFactory {
    public static Dataset create(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, TextVocab.textDataset);
    }

    public static Dataset create(Dataset base, TextIndex textIndex) {
        return TextDatasetFactory.create(base, textIndex, false);
    }

    public static Dataset create(Dataset base, TextIndex textIndex, boolean closeIndexOnDSGClose) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose);
        return DatasetFactory.create(dsg);
    }

    public static Dataset create(Dataset base, TextIndex textIndex, boolean closeIndexOnDSGClose, TextDocProducer producer) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose, producer);
        return DatasetFactory.create(dsg);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex) {
        return TextDatasetFactory.create(dsg, textIndex, false);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex, boolean closeIndexOnDSGClose) {
        return TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose, null);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex, boolean closeIndexOnDSGClose, TextDocProducer producer) {
        if (producer == null) {
            producer = new TextDocProducerTriples(textIndex);
        }
        DatasetGraphText dsgt = new DatasetGraphText(dsg, textIndex, producer, closeIndexOnDSGClose);
        Context c = dsgt.getContext();
        c.set(TextQuery.textIndex, textIndex);
        return dsgt;
    }

    public static TextIndex createLuceneIndex(Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndexLucene index = new TextIndexLucene(directory, def, queryAnalyzer);
        return index;
    }

    public static Dataset createLucene(Dataset base, Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, def, queryAnalyzer);
        return TextDatasetFactory.create(base, index, true);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, def, queryAnalyzer);
        return TextDatasetFactory.create(base, index, true);
    }

    public static TextIndex createSolrIndex(SolrServer server, EntityDefinition entMap) {
        TextIndexSolr index = new TextIndexSolr(server, entMap);
        return index;
    }

    public static Dataset createSolrIndex(Dataset base, SolrServer server, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createSolrIndex(server, entMap);
        return TextDatasetFactory.create(base, index, true);
    }

    public static DatasetGraph createSolrIndex(DatasetGraph base, SolrServer server, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createSolrIndex(server, entMap);
        return TextDatasetFactory.create(base, index, true);
    }

    static {
        TextQuery.init();
    }
}

