/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.QuadAction;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextQueryFuncs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDocProducerTriples
implements TextDocProducer {
    private static Logger log = LoggerFactory.getLogger(TextDocProducerTriples.class);
    private final EntityDefinition defn;
    private final TextIndex indexer;
    private final ThreadLocal<Boolean> inTransaction = new ThreadLocal();

    public TextDocProducerTriples(TextIndex indexer) {
        this.defn = indexer.getDocDef();
        this.indexer = indexer;
        this.inTransaction.set(false);
    }

    @Override
    public void start() {
        this.inTransaction.set(true);
    }

    @Override
    public void finish() {
        this.inTransaction.set(false);
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (qaction != QuadAction.ADD) {
            return;
        }
        Entity entity = TextQueryFuncs.entityFromQuad(this.defn, g, s, p, o);
        if (entity != null) {
            this.indexer.addEntity(entity);
            if (!this.inTransaction.get().booleanValue()) {
                this.indexer.commit();
            }
        }
    }
}

