/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexLucene
implements TextIndex {
    private static Logger log = LoggerFactory.getLogger(TextIndexLucene.class);
    private static int MAX_N = 10000;
    public static final Version VER = Version.LUCENE_46;
    public static final FieldType ftIRI = new FieldType();
    public static final FieldType ftString;
    public static final FieldType ftText;
    private final EntityDefinition docDef;
    private final Directory directory;
    private final Analyzer analyzer;
    private final Analyzer queryAnalyzer;
    private volatile IndexWriter indexWriter;

    public TextIndexLucene(Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        this.directory = directory;
        this.docDef = def;
        HashMap<String, Analyzer> analyzerPerField = new HashMap<String, Analyzer>();
        analyzerPerField.put(def.getEntityField(), new KeywordAnalyzer());
        if (def.getGraphField() != null) {
            analyzerPerField.put(def.getGraphField(), new KeywordAnalyzer());
        }
        for (String field : def.fields()) {
            Analyzer analyzer = def.getAnalyzer(field);
            if (analyzer == null) continue;
            analyzerPerField.put(field, analyzer);
        }
        this.analyzer = new PerFieldAnalyzerWrapper(new StandardAnalyzer(VER), analyzerPerField);
        this.queryAnalyzer = null != queryAnalyzer ? queryAnalyzer : this.analyzer;
        this.openIndexWriter();
    }

    private void openIndexWriter() {
        IndexWriterConfig wConfig = new IndexWriterConfig(VER, this.analyzer);
        try {
            this.indexWriter = new IndexWriter(this.directory, wConfig);
            this.indexWriter.commit();
        }
        catch (IOException e2) {
            throw new TextIndexException(e2);
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public void prepareCommit() {
        try {
            this.indexWriter.prepareCommit();
        }
        catch (IOException e2) {
            throw new TextIndexException(e2);
        }
    }

    @Override
    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e2) {
            throw new TextIndexException(e2);
        }
    }

    @Override
    public void rollback() {
        IndexWriter idx = this.indexWriter;
        this.indexWriter = null;
        try {
            idx.rollback();
        }
        catch (IOException e2) {
            throw new TextIndexException(e2);
        }
        this.openIndexWriter();
    }

    @Override
    public void close() {
        try {
            this.indexWriter.close();
        }
        catch (IOException ex) {
            throw new TextIndexException(ex);
        }
    }

    @Override
    public void addEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            log.debug("Add entity: " + entity);
        }
        try {
            Document doc = this.doc(entity);
            this.indexWriter.addDocument(doc);
        }
        catch (IOException e2) {
            throw new TextIndexException(e2);
        }
    }

    private Document doc(Entity entity) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), entity.getId(), ftIRI);
        doc.add(entField);
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            Field gField = new Field(graphField, entity.getGraph(), ftString);
            doc.add(gField);
        }
        for (Map.Entry<String, Object> e2 : entity.getMap().entrySet()) {
            Field field = new Field(e2.getKey(), (String)e2.getValue(), ftText);
            doc.add(field);
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        try {
            DirectoryReader indexReader = DirectoryReader.open(this.directory);
            List<Map<String, Node>> x = this.get$(indexReader, uri);
            if (x.size() == 0) {
                return null;
            }
            return x.get(0);
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }

    private static Query parseQuery(String queryString, String primaryField, Analyzer analyzer) throws ParseException {
        QueryParser queryParser = new QueryParser(VER, primaryField, analyzer);
        queryParser.setAllowLeadingWildcard(true);
        Query query2 = queryParser.parse(queryString);
        return query2;
    }

    private List<Map<String, Node>> get$(IndexReader indexReader, String uri) throws ParseException, IOException {
        String escaped = QueryParserBase.escape(uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        Query query2 = TextIndexLucene.parseQuery(qs, this.docDef.getPrimaryField(), this.queryAnalyzer);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        ScoreDoc[] sDocs = indexSearcher.search((Query)query2, (int)1).scoreDocs;
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        for (ScoreDoc sd : sDocs) {
            Document doc = indexSearcher.doc(sd.doc);
            String[] x = doc.getValues(this.docDef.getEntityField());
            if (x.length != 1) {
                // empty if block
            }
            String uriStr = x[0];
            HashMap<String, Node> record = new HashMap<String, Node>();
            Node entity = NodeFactory.createURI(uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                String[] values;
                for (String v : values = doc.getValues(f)) {
                    Node n = this.entryToNode(v);
                    record.put(f, n);
                }
                records.add(record);
            }
        }
        return records;
    }

    @Override
    public List<Node> query(String qs) {
        return this.query(qs, MAX_N);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Node> query(String qs, int limit) {
        try (DirectoryReader indexReader = DirectoryReader.open(this.directory);){
            List<Node> list = this.query$(indexReader, qs, limit);
            return list;
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }

    private List<Node> query$(IndexReader indexReader, String qs, int limit) throws ParseException, IOException {
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        Query query2 = TextIndexLucene.parseQuery(qs, this.docDef.getPrimaryField(), this.queryAnalyzer);
        if (limit <= 0) {
            limit = MAX_N;
        }
        ScoreDoc[] sDocs = indexSearcher.search((Query)query2, (int)limit).scoreDocs;
        ArrayList<Node> results = new ArrayList<Node>();
        for (ScoreDoc sd : sDocs) {
            String[] values;
            Document doc = indexSearcher.doc(sd.doc);
            for (String v : values = doc.getValues(this.docDef.getEntityField())) {
                Node n = TextQueryFuncs.stringToNode(v);
                results.add(n);
            }
        }
        return results;
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode(v, null, null);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexed(true);
        ftIRI.freeze();
        ftString = StringField.TYPE_NOT_STORED;
        ftText = TextField.TYPE_NOT_STORED;
    }
}

