/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterExtendByVar;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex server = null;
    private boolean warningIssued = false;

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.server = TextQueryPF.chooseTextIndex(dsg);
        if (!argSubject.isNode()) {
            throw new QueryBuildException("Subject is not a single node: " + argSubject);
        }
        if (argObject.isList()) {
            List<Node> list = argObject.getArgList();
            if (list.size() == 0) {
                throw new QueryBuildException("Zero-length argument list");
            }
            if (list.size() > 4) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
        }
    }

    private static TextIndex chooseTextIndex(DatasetGraph dsg) {
        Context c = dsg.getContext();
        Object obj = dsg.getContext().get(TextQuery.textIndex);
        if (obj != null) {
            try {
                return (TextIndex)obj;
            }
            catch (ClassCastException ex) {
                Log.warn(TextQueryPF.class, "Context setting '" + TextQuery.textIndex + "'is not a TextIndex");
            }
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        Log.warn(TextQueryPF.class, "Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    @Override
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterator qIter;
        if (this.server == null) {
            if (!this.warningIssued) {
                Log.warn(this.getClass(), "No text index - no text search performed");
                this.warningIssued = true;
            }
            return IterLib.result(binding, execCxt);
        }
        DatasetGraph dsg = execCxt.getDataset();
        argSubject = Substitute.substitute(argSubject, binding);
        argObject = Substitute.substitute(argObject, binding);
        if (!argSubject.isNode()) {
            throw new InternalErrorException("Subject is not a node (it was earlier!)");
        }
        Node s = argSubject.getArg();
        if (s.isLiteral()) {
            return IterLib.noResults(execCxt);
        }
        StrMatch match = this.objectToStruct(argObject);
        if (match == null) {
            return IterLib.noResults(execCxt);
        }
        QueryIterator queryIterator = qIter = Var.isVar(s) ? this.variableSubject(binding, s, match, execCxt) : this.concreteSubject(binding, s, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, match.getLimit(), execCxt);
        }
        return qIter;
    }

    private QueryIterator variableSubject(Binding binding, Node s, StrMatch match, ExecutionContext execCxt) {
        Var v = Var.alloc(s);
        List<Node> r = this.query(match.getQueryString(), match.getLimit(), execCxt);
        r = Iter.iter(r).distinct().toList();
        QueryIterExtendByVar qIter = new QueryIterExtendByVar(binding, v, r.iterator(), execCxt);
        return qIter;
    }

    private QueryIterator concreteSubject(Binding binding, Node s, StrMatch match, ExecutionContext execCxt) {
        if (!s.isURI()) {
            log.warn("Subject not a URI: " + s);
            return IterLib.noResults(execCxt);
        }
        String qs = match.getQueryString();
        List<Node> x = this.query(match.getQueryString(), -1, execCxt);
        if (x == null || !x.contains(s)) {
            return IterLib.noResults(execCxt);
        }
        return IterLib.result(binding, execCxt);
    }

    private List<Node> query(String queryString, int limit, ExecutionContext execCxt) {
        GraphView activeGraph;
        if (this.server.getDocDef().getGraphField() != null && execCxt.getActiveGraph() instanceof GraphView && !Quad.isUnionGraph((activeGraph = (GraphView)execCxt.getActiveGraph()).getGraphName())) {
            String uri = activeGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(activeGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
            String escaped = QueryParserBase.escape(uri);
            String qs2 = this.server.getDocDef().getGraphField() + ":" + escaped;
            queryString = "(" + queryString + ") AND " + qs2;
        }
        Explain.explain(execCxt.getContext(), "Text query: " + queryString);
        if (log.isDebugEnabled()) {
            log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
        }
        return this.server.query(queryString, limit);
    }

    private StrMatch objectToStruct(PropFuncArg argObject) {
        EntityDefinition docDef = this.server.getDocDef();
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                log.warn("Object to text query is not a literal");
                return null;
            }
            RDFDatatype dt = o.getLiteralDatatype();
            if (dt != null && dt != XSDDatatype.XSDstring) {
                log.warn("Object to text query is not a string");
                return null;
            }
            String qs = o.getLiteralLexicalForm();
            return new StrMatch(null, qs, -1, 0.0f);
        }
        List<Node> list = argObject.getArgList();
        if (list.size() == 0 || list.size() > 3) {
            throw new TextIndexException("Change in object list size");
        }
        Node predicate = null;
        String field = null;
        int idx = 0;
        Node x = list.get(0);
        if (x.isURI()) {
            predicate = x;
            if (++idx >= list.size()) {
                throw new TextIndexException("Property specificied but no query string : " + list);
            }
            x = list.get(idx);
            field = docDef.getField(predicate);
            if (field == null) {
                log.warn("Predicate not indexed: " + predicate);
                return null;
            }
        }
        if (!x.isLiteral()) {
            log.warn("Text query string is not a literal " + list);
            return null;
        }
        if (x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            log.warn("Text query is not a string " + list);
            return null;
        }
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = list.get(idx);
            ++idx;
            int v = NodeFactoryExtra.nodeToInt(x);
            limit = v < 0 ? -1 : v;
        }
        String qs = queryString;
        if (field != null) {
            qs = field + ":" + qs;
        }
        return new StrMatch(predicate, qs, limit, score);
    }

    class StrMatch {
        private final Node property;
        private final String queryString;
        private final int limit;
        private final float scoreLimit;

        public StrMatch(Node property, String queryString, int limit, float scoreLimit) {
            this.property = property;
            this.queryString = queryString;
            this.limit = limit;
            this.scoreLimit = scoreLimit;
        }

        public Node getProperty() {
            return this.property;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public int getLimit() {
            return this.limit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }
    }
}

