/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;

public class StreamWriterTriX
implements StreamRDF {
    private static String rdfXMLLiteral = XMLLiteralType.theXMLLiteralType.getURI();
    private IndentedWriter out;
    private Node gn = null;
    private boolean inGraph = false;
    private PrefixMap pmap = PrefixMapFactory.create();
    private int depth = 0;

    public StreamWriterTriX(OutputStream out) {
        this.out = new IndentedWriter(out);
    }

    public StreamWriterTriX(IndentedWriter out) {
        this.out = out;
    }

    @Override
    public void start() {
        if (this.depth == 0) {
            StreamWriterTriX.startXML(this.out);
            StreamWriterTriX.startTag(this.out, "TriX", "xmlns", "http://www.w3.org/2004/03/trix/trix-1/");
            this.out.println();
        }
        ++this.depth;
    }

    @Override
    public void finish() {
        --this.depth;
        if (this.depth != 0) {
            return;
        }
        if (this.inGraph) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
        }
        StreamWriterTriX.endTag(this.out, "TriX");
        this.out.println();
        this.out.flush();
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.pmap.add(prefix, iri2);
    }

    @Override
    public void triple(Triple triple) {
        if (this.inGraph && this.gn != null) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
            this.inGraph = false;
        }
        if (!this.inGraph) {
            StreamWriterTriX.startTag(this.out, "graph");
            this.out.println();
        }
        this.inGraph = true;
        this.gn = null;
        StreamWriterTriX.write(this.out, triple, this.pmap);
    }

    @Override
    public void quad(Quad quad) {
        Node g = quad.getGraph();
        if (g == null || Quad.isDefaultGraph(g)) {
            this.triple(quad.asTriple());
            return;
        }
        if (this.inGraph && !Objects.equals(g, this.gn)) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
            this.inGraph = false;
        }
        if (!this.inGraph) {
            StreamWriterTriX.startTag(this.out, "graph");
            this.out.println();
            if (this.gn == null || !Quad.isDefaultGraph(this.gn)) {
                this.gn = quad.getGraph();
                StreamWriterTriX.write(this.out, this.gn, this.pmap);
            }
        }
        this.inGraph = true;
        this.gn = g;
        StreamWriterTriX.write(this.out, quad.asTriple(), this.pmap);
    }

    static void write(IndentedWriter out, Triple triple, PrefixMap prefixMap) {
        out.println("<triple>");
        out.incIndent();
        StreamWriterTriX.write(out, triple.getSubject(), prefixMap);
        StreamWriterTriX.write(out, triple.getPredicate(), prefixMap);
        StreamWriterTriX.write(out, triple.getObject(), prefixMap);
        out.decIndent();
        out.println("</triple>");
    }

    static void write(IndentedWriter out, Node node, PrefixMap prefixMap) {
        if (node.isURI()) {
            String uri = node.getURI();
            StreamWriterTriX.startTag(out, "uri");
            StreamWriterTriX.writeText(out, node.getURI());
            StreamWriterTriX.endTag(out, "uri");
            out.println();
            return;
        }
        if (node.isBlank()) {
            StreamWriterTriX.startTag(out, "id");
            StreamWriterTriX.writeText(out, node.getBlankNodeLabel());
            StreamWriterTriX.endTag(out, "id");
            out.println();
            return;
        }
        if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            if (lang != null && lang.isEmpty()) {
                lang = null;
            }
            String dt = node.getLiteralDatatypeURI();
            if (lang != null) {
                StreamWriterTriX.startTag(out, "plainLiteral", "xml:lang", lang);
                StreamWriterTriX.writeTextNoIndent(out, node.getLiteralLexicalForm());
                StreamWriterTriX.endTag(out, "plainLiteral");
                out.println();
                return;
            }
            if (dt == null) {
                StreamWriterTriX.startTag(out, "plainLiteral");
                StreamWriterTriX.writeTextNoIndent(out, node.getLiteralLexicalForm());
                StreamWriterTriX.endTag(out, "plainLiteral");
                out.println();
                return;
            }
            StreamWriterTriX.startTag(out, "typedLiteral", "datatype", dt);
            String lex = node.getLiteralLexicalForm();
            if (rdfXMLLiteral.equals(dt)) {
                int x = out.getAbsoluteIndent();
                out.setAbsoluteIndent(0);
                out.print(lex);
                out.setAbsoluteIndent(x);
            } else {
                StreamWriterTriX.writeTextNoIndent(out, lex);
            }
            StreamWriterTriX.endTag(out, "typedLiteral");
            out.println();
            return;
        }
        throw new RiotException("Not a concrete node: " + node);
    }

    static void writeText(IndentedWriter out, String string) {
        string = Util.substituteEntitiesInElementContent(string);
        out.print(string);
    }

    static void writeTextNoIndent(IndentedWriter out, String string) {
        int x = out.getAbsoluteIndent();
        out.setAbsoluteIndent(0);
        StreamWriterTriX.writeText(out, string);
        out.setAbsoluteIndent(x);
    }

    static void startXML(IndentedWriter out) {
    }

    static void startTag(IndentedWriter out, String text) {
        out.print("<");
        out.print(text);
        out.print(">");
        out.incIndent();
    }

    static void startTag(IndentedWriter out, String text, String attr, String attrValue) {
        out.print("<");
        out.print(text);
        out.print(" ");
        out.print(attr);
        out.print("=\"");
        attrValue = Util.substituteStandardEntities(attrValue);
        out.print(attrValue);
        out.print("\"");
        out.print(">");
        out.incIndent();
    }

    static void endTag(IndentedWriter out, String text) {
        out.decIndent();
        out.print("</");
        out.print(text);
        out.print(">");
    }
}

