/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterFlushQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.NumericUpdate;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;

final class DocumentsWriter {
    private final Directory directory;
    private volatile boolean closed;
    private final InfoStream infoStream;
    private final LiveIndexWriterConfig config;
    private final AtomicInteger numDocsInRAM = new AtomicInteger(0);
    volatile DocumentsWriterDeleteQueue deleteQueue = new DocumentsWriterDeleteQueue();
    private final DocumentsWriterFlushQueue ticketQueue = new DocumentsWriterFlushQueue();
    private volatile boolean pendingChangesInCurrentFullFlush;
    final DocumentsWriterPerThreadPool perThreadPool;
    final FlushPolicy flushPolicy;
    final DocumentsWriterFlushControl flushControl;
    private final IndexWriter writer;
    private final Queue<IndexWriter.Event> events;
    private volatile DocumentsWriterDeleteQueue currentFullFlushDelQueue = null;

    DocumentsWriter(IndexWriter writer, LiveIndexWriterConfig config, Directory directory) {
        this.directory = directory;
        this.config = config;
        this.infoStream = config.getInfoStream();
        this.perThreadPool = config.getIndexerThreadPool();
        this.flushPolicy = config.getFlushPolicy();
        this.writer = writer;
        this.events = new ConcurrentLinkedQueue<IndexWriter.Event>();
        this.flushControl = new DocumentsWriterFlushControl(this, config, writer.bufferedUpdatesStream);
    }

    synchronized boolean deleteQueries(Query ... queries) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        deleteQueue.addDelete(queries);
        this.flushControl.doOnDelete();
        return this.applyAllDeletes(deleteQueue);
    }

    synchronized boolean deleteTerms(Term ... terms) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        deleteQueue.addDelete(terms);
        this.flushControl.doOnDelete();
        return this.applyAllDeletes(deleteQueue);
    }

    synchronized boolean updateNumericDocValue(Term term, String field, Long value) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        deleteQueue.addNumericUpdate(new NumericUpdate(term, field, value));
        this.flushControl.doOnDelete();
        return this.applyAllDeletes(deleteQueue);
    }

    DocumentsWriterDeleteQueue currentDeleteSession() {
        return this.deleteQueue;
    }

    private final boolean applyAllDeletes(DocumentsWriterDeleteQueue deleteQueue) throws IOException {
        if (this.flushControl.getAndResetApplyAllDeletes()) {
            if (deleteQueue != null && !this.flushControl.isFullFlush()) {
                this.ticketQueue.addDeletes(deleteQueue);
            }
            this.putEvent(ApplyDeletesEvent.INSTANCE);
            return true;
        }
        return false;
    }

    final int purgeBuffer(IndexWriter writer, boolean forced) throws IOException {
        if (forced) {
            return this.ticketQueue.forcePurge(writer);
        }
        return this.ticketQueue.tryPurge(writer);
    }

    int getNumDocs() {
        return this.numDocsInRAM.get();
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort(IndexWriter writer) {
        assert (!Thread.holdsLock(writer)) : "IndexWriter lock should never be hold when aborting";
        boolean success = false;
        HashSet<String> newFilesSet = new HashSet<String>();
        try {
            this.deleteQueue.clear();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "abort");
            }
            int limit = this.perThreadPool.getActiveThreadState();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                try {
                    this.abortThreadState(perThread, newFilesSet);
                    continue;
                }
                finally {
                    perThread.unlock();
                }
            }
            this.flushControl.abortPendingFlushes(newFilesSet);
            this.putEvent(new DeleteNewFilesEvent(newFilesSet));
            this.flushControl.waitForFlush();
            success = true;
        }
        finally {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort; abortedFiles=" + newFilesSet + " success=" + success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockAndAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "lockAndAbortAll");
        }
        boolean success = false;
        try {
            this.deleteQueue.clear();
            int limit = this.perThreadPool.getMaxThreadStates();
            HashSet<String> newFilesSet = new HashSet<String>();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                this.abortThreadState(perThread, newFilesSet);
            }
            this.deleteQueue.clear();
            this.flushControl.abortPendingFlushes(newFilesSet);
            this.putEvent(new DeleteNewFilesEvent(newFilesSet));
            this.flushControl.waitForFlush();
            success = true;
        }
        finally {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=" + success);
            }
            if (!success) {
                this.unlockAllAfterAbortAll(indexWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void abortThreadState(DocumentsWriterPerThreadPool.ThreadState perThread, Set<String> newFiles) {
        assert (perThread.isHeldByCurrentThread());
        if (perThread.isActive()) {
            if (perThread.isInitialized()) {
                try {
                    this.subtractFlushedNumDocs(perThread.dwpt.getNumDocsInRAM());
                    perThread.dwpt.abort(newFiles);
                }
                finally {
                    perThread.dwpt.checkAndResetHasAborted();
                    this.flushControl.doOnAbort(perThread);
                }
            } else {
                this.flushControl.doOnAbort(perThread);
            }
        } else assert (this.closed);
    }

    final synchronized void unlockAllAfterAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "unlockAll");
        }
        int limit = this.perThreadPool.getMaxThreadStates();
        for (int i = 0; i < limit; ++i) {
            try {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                if (!perThread.isHeldByCurrentThread()) continue;
                perThread.unlock();
                continue;
            }
            catch (Throwable e2) {
                if (!this.infoStream.isEnabled("DW")) continue;
                this.infoStream.message("DW", "unlockAll: could not unlock state: " + i + " msg:" + e2.getMessage());
            }
        }
    }

    boolean anyChanges() {
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "anyChanges? numDocsInRam=" + this.numDocsInRAM.get() + " deletes=" + this.anyDeletions() + " hasTickets:" + this.ticketQueue.hasTickets() + " pendingChangesInFullFlush: " + this.pendingChangesInCurrentFullFlush);
        }
        return this.numDocsInRAM.get() != 0 || this.anyDeletions() || this.ticketQueue.hasTickets() || this.pendingChangesInCurrentFullFlush;
    }

    public int getBufferedDeleteTermsSize() {
        return this.deleteQueue.getBufferedUpdatesTermsSize();
    }

    public int getNumBufferedDeleteTerms() {
        return this.deleteQueue.numGlobalTermDeletes();
    }

    public boolean anyDeletions() {
        return this.deleteQueue.anyChanges();
    }

    void close() {
        this.closed = true;
        this.flushControl.setClosed();
    }

    private boolean preUpdate() throws IOException {
        this.ensureOpen();
        boolean hasEvents = false;
        if (this.flushControl.anyStalledThreads() || this.flushControl.numQueuedFlushes() > 0) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "DocumentsWriter has queued dwpt; will hijack this thread to flush pending segment(s)");
            }
            while (true) {
                DocumentsWriterPerThread flushingDWPT;
                if ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                    hasEvents |= this.doFlush(flushingDWPT);
                    continue;
                }
                if (this.infoStream.isEnabled("DW") && this.flushControl.anyStalledThreads()) {
                    this.infoStream.message("DW", "WARNING DocumentsWriter has stalled threads; waiting");
                }
                this.flushControl.waitIfStalled();
                if (this.flushControl.numQueuedFlushes() == 0) break;
            }
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "continue indexing after helping out flushing DocumentsWriter is healthy");
            }
        }
        return hasEvents;
    }

    private boolean postUpdate(DocumentsWriterPerThread flushingDWPT, boolean hasEvents) throws IOException {
        hasEvents |= this.applyAllDeletes(this.deleteQueue);
        if (flushingDWPT != null) {
            hasEvents |= this.doFlush(flushingDWPT);
        } else {
            DocumentsWriterPerThread nextPendingFlush = this.flushControl.nextPendingFlush();
            if (nextPendingFlush != null) {
                hasEvents |= this.doFlush(nextPendingFlush);
            }
        }
        return hasEvents;
    }

    private final void ensureInitialized(DocumentsWriterPerThreadPool.ThreadState state) {
        if (state.isActive() && state.dwpt == null) {
            FieldInfos.Builder infos = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
            state.dwpt = new DocumentsWriterPerThread(this.writer.newSegmentName(), this.directory, this.config, this.infoStream, this.deleteQueue, infos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer, Term delTerm) throws IOException {
        DocumentsWriterPerThread flushingDWPT;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            if (!perThread.isActive()) {
                this.ensureOpen();
                assert (false) : "perThread is not active but we are still open";
            }
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                int docCount = dwpt.updateDocuments(docs, analyzer, delTerm);
                this.numDocsInRAM.addAndGet(docCount);
            }
            finally {
                if (dwpt.checkAndResetHasAborted()) {
                    if (!dwpt.pendingFilesToDelete().isEmpty()) {
                        this.putEvent(new DeleteNewFilesEvent(dwpt.pendingFilesToDelete()));
                    }
                    this.subtractFlushedNumDocs(dwptNumDocs);
                    this.flushControl.doOnAbort(perThread);
                }
            }
            boolean isUpdate = delTerm != null;
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
        }
        finally {
            perThread.unlock();
        }
        return this.postUpdate(flushingDWPT, hasEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer, Term delTerm) throws IOException {
        DocumentsWriterPerThread flushingDWPT;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            if (!perThread.isActive()) {
                this.ensureOpen();
                assert (false) : "perThread is not active but we are still open";
            }
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                dwpt.updateDocument(doc, analyzer, delTerm);
                this.numDocsInRAM.incrementAndGet();
            }
            finally {
                if (dwpt.checkAndResetHasAborted()) {
                    if (!dwpt.pendingFilesToDelete().isEmpty()) {
                        this.putEvent(new DeleteNewFilesEvent(dwpt.pendingFilesToDelete()));
                    }
                    this.subtractFlushedNumDocs(dwptNumDocs);
                    this.flushControl.doOnAbort(perThread);
                }
            }
            boolean isUpdate = delTerm != null;
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
        }
        finally {
            perThread.unlock();
        }
        return this.postUpdate(flushingDWPT, hasEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(DocumentsWriterPerThread flushingDWPT) throws IOException {
        double ramBufferSizeMB;
        boolean hasEvents = false;
        while (flushingDWPT != null) {
            hasEvents = true;
            boolean success = false;
            DocumentsWriterFlushQueue.SegmentFlushTicket ticket = null;
            try {
                assert (this.currentFullFlushDelQueue == null || flushingDWPT.deleteQueue == this.currentFullFlushDelQueue) : "expected: " + this.currentFullFlushDelQueue + "but was: " + flushingDWPT.deleteQueue + " " + this.flushControl.isFullFlush();
                try {
                    ticket = this.ticketQueue.addFlushTicket(flushingDWPT);
                    int flushingDocsInRam = flushingDWPT.getNumDocsInRAM();
                    boolean dwptSuccess = false;
                    try {
                        DocumentsWriterPerThread.FlushedSegment newSegment = flushingDWPT.flush();
                        this.ticketQueue.addSegment(ticket, newSegment);
                        dwptSuccess = true;
                    }
                    finally {
                        this.subtractFlushedNumDocs(flushingDocsInRam);
                        if (!flushingDWPT.pendingFilesToDelete().isEmpty()) {
                            this.putEvent(new DeleteNewFilesEvent(flushingDWPT.pendingFilesToDelete()));
                            hasEvents = true;
                        }
                        if (!dwptSuccess) {
                            this.putEvent(new FlushFailedEvent(flushingDWPT.getSegmentInfo()));
                            hasEvents = true;
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success && ticket != null) {
                        this.ticketQueue.markTicketFailed(ticket);
                    }
                }
                if (this.ticketQueue.getTicketCount() >= this.perThreadPool.getActiveThreadState()) {
                    this.putEvent(ForcedPurgeEvent.INSTANCE);
                    break;
                }
            }
            finally {
                this.flushControl.doAfterFlush(flushingDWPT);
                flushingDWPT.checkAndResetHasAborted();
            }
            flushingDWPT = this.flushControl.nextPendingFlush();
        }
        if (hasEvents) {
            this.putEvent(MergePendingEvent.INSTANCE);
        }
        if ((ramBufferSizeMB = this.config.getRAMBufferSizeMB()) != -1.0 && (double)this.flushControl.getDeleteBytesUsed() > 1048576.0 * ramBufferSizeMB / 2.0) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "force apply deletes bytesUsed=" + this.flushControl.getDeleteBytesUsed() + " vs ramBuffer=" + 1048576.0 * ramBufferSizeMB);
            }
            hasEvents = true;
            if (!this.applyAllDeletes(this.deleteQueue)) {
                this.putEvent(ApplyDeletesEvent.INSTANCE);
            }
        }
        return hasEvents;
    }

    final void subtractFlushedNumDocs(int numFlushed) {
        int oldValue = this.numDocsInRAM.get();
        while (!this.numDocsInRAM.compareAndSet(oldValue, oldValue - numFlushed)) {
            oldValue = this.numDocsInRAM.get();
        }
    }

    private synchronized boolean setFlushingDeleteQueue(DocumentsWriterDeleteQueue session) {
        this.currentFullFlushDelQueue = session;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean flushAllThreads(IndexWriter indexWriter) throws IOException {
        DocumentsWriterDeleteQueue flushingDeleteQueue;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", Thread.currentThread().getName() + " startFullFlush");
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingChangesInCurrentFullFlush = this.anyChanges();
            flushingDeleteQueue = this.deleteQueue;
            this.flushControl.markForFullFlush();
            assert (this.setFlushingDeleteQueue(flushingDeleteQueue));
        }
        assert (this.currentFullFlushDelQueue != null);
        assert (this.currentFullFlushDelQueue != this.deleteQueue);
        boolean anythingFlushed = false;
        try {
            DocumentsWriterPerThread flushingDWPT;
            while ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                anythingFlushed |= this.doFlush(flushingDWPT);
            }
            this.flushControl.waitForFlush();
            if (!anythingFlushed && flushingDeleteQueue.anyChanges()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", Thread.currentThread().getName() + ": flush naked frozen global deletes");
                }
                this.ticketQueue.addDeletes(flushingDeleteQueue);
            }
            this.ticketQueue.forcePurge(indexWriter);
            assert (!flushingDeleteQueue.anyChanges() && !this.ticketQueue.hasTickets());
        }
        finally {
            assert (flushingDeleteQueue == this.currentFullFlushDelQueue);
        }
        return anythingFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishFullFlush(boolean success) {
        try {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", Thread.currentThread().getName() + " finishFullFlush success=" + success);
            }
            assert (this.setFlushingDeleteQueue(null));
            if (success) {
                this.flushControl.finishFullFlush();
            } else {
                HashSet<String> newFilesSet = new HashSet<String>();
                this.flushControl.abortFullFlushes(newFilesSet);
                this.putEvent(new DeleteNewFilesEvent(newFilesSet));
            }
        }
        finally {
            this.pendingChangesInCurrentFullFlush = false;
        }
    }

    public LiveIndexWriterConfig getIndexWriterConfig() {
        return this.config;
    }

    private void putEvent(IndexWriter.Event event) {
        this.events.add(event);
    }

    public Queue<IndexWriter.Event> eventQueue() {
        return this.events;
    }

    static class DeleteNewFilesEvent
    implements IndexWriter.Event {
        private final Collection<String> files;

        public DeleteNewFilesEvent(Collection<String> files) {
            this.files = files;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.deleteNewFiles(this.files);
        }
    }

    static class FlushFailedEvent
    implements IndexWriter.Event {
        private final SegmentInfo info;

        public FlushFailedEvent(SegmentInfo info) {
            this.info = info;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.flushFailed(this.info);
        }
    }

    static final class ForcedPurgeEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new ForcedPurgeEvent();
        private int instCount = 0;

        private ForcedPurgeEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.purge(true);
        }
    }

    static final class MergePendingEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new MergePendingEvent();
        private int instCount = 0;

        private MergePendingEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.doAfterSegmentFlushed(triggerMerge, forcePurge);
        }
    }

    static final class ApplyDeletesEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new ApplyDeletesEvent();
        private int instCount = 0;

        private ApplyDeletesEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.applyDeletesAndPurge(true);
        }
    }
}

