/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.w3c.dom.Element;

public class TermsQueryBuilder
implements QueryBuilder {
    private final Analyzer analyzer;

    public TermsQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Query getQuery(Element e2) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e2, "fieldName");
        String text = DOMUtils.getNonBlankTextOrFail(e2);
        BooleanQuery bq = new BooleanQuery(DOMUtils.getAttribute(e2, "disableCoord", false));
        bq.setMinimumNumberShouldMatch(DOMUtils.getAttribute(e2, "minimumNumberShouldMatch", 0));
        TokenStream ts = null;
        try {
            ts = this.analyzer.tokenStream(fieldName, text);
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            Term term = null;
            BytesRef bytes = termAtt.getBytesRef();
            ts.reset();
            while (ts.incrementToken()) {
                termAtt.fillBytesRef();
                term = new Term(fieldName, BytesRef.deepCopyOf(bytes));
                bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
            }
            ts.end();
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Error constructing terms from index:" + ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(ts);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(ts);
        bq.setBoost(DOMUtils.getAttribute(e2, "boost", 1.0f));
        return bq;
    }
}

