/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.PointPrefixTreeFieldCacheProvider;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.ShapeFieldCacheDistanceValueSource;

public abstract class PrefixTreeStrategy
extends SpatialStrategy {
    protected final SpatialPrefixTree grid;
    private final Map<String, PointPrefixTreeFieldCacheProvider> provider = new ConcurrentHashMap<String, PointPrefixTreeFieldCacheProvider>();
    protected final boolean simplifyIndexedCells;
    protected int defaultFieldValuesArrayLen = 2;
    protected double distErrPct = 0.025;
    public static final FieldType FIELD_TYPE = new FieldType();

    public PrefixTreeStrategy(SpatialPrefixTree grid, String fieldName, boolean simplifyIndexedCells) {
        super(grid.getSpatialContext(), fieldName);
        this.grid = grid;
        this.simplifyIndexedCells = simplifyIndexedCells;
    }

    public void setDefaultFieldValuesArrayLen(int defaultFieldValuesArrayLen) {
        this.defaultFieldValuesArrayLen = defaultFieldValuesArrayLen;
    }

    public double getDistErrPct() {
        return this.distErrPct;
    }

    public void setDistErrPct(double distErrPct) {
        this.distErrPct = distErrPct;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        double distErr = SpatialArgs.calcDistanceFromErrPct(shape, this.distErrPct, this.ctx);
        return this.createIndexableFields(shape, distErr);
    }

    public Field[] createIndexableFields(Shape shape, double distErr) {
        int detailLevel = this.grid.getLevelForDistance(distErr);
        List<Cell> cells = this.grid.getCells(shape, detailLevel, true, this.simplifyIndexedCells);
        Field field = new Field(this.getFieldName(), (TokenStream)new CellTokenStream(cells.iterator()), FIELD_TYPE);
        return new Field[]{field};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        PointPrefixTreeFieldCacheProvider p = this.provider.get(this.getFieldName());
        if (p == null) {
            PrefixTreeStrategy prefixTreeStrategy = this;
            synchronized (prefixTreeStrategy) {
                p = this.provider.get(this.getFieldName());
                if (p == null) {
                    p = new PointPrefixTreeFieldCacheProvider(this.grid, this.getFieldName(), this.defaultFieldValuesArrayLen);
                    this.provider.put(this.getFieldName(), p);
                }
            }
        }
        return new ShapeFieldCacheDistanceValueSource(this.ctx, p, queryPoint, multiplier);
    }

    public SpatialPrefixTree getGrid() {
        return this.grid;
    }

    static {
        FIELD_TYPE.setIndexed(true);
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        FIELD_TYPE.freeze();
    }

    static final class CellTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private Iterator<Cell> iter = null;
        CharSequence nextTokenStringNeedingLeaf = null;

        public CellTokenStream(Iterator<Cell> tokens2) {
            this.iter = tokens2;
        }

        @Override
        public boolean incrementToken() {
            this.clearAttributes();
            if (this.nextTokenStringNeedingLeaf != null) {
                this.termAtt.append(this.nextTokenStringNeedingLeaf);
                this.termAtt.append('+');
                this.nextTokenStringNeedingLeaf = null;
                return true;
            }
            if (this.iter.hasNext()) {
                Cell cell = this.iter.next();
                String token = cell.getTokenString();
                this.termAtt.append((CharSequence)token);
                if (cell.isLeaf()) {
                    this.nextTokenStringNeedingLeaf = token;
                }
                return true;
            }
            return false;
        }
    }
}

