/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.util.CachingDoubleValueSource;
import org.apache.lucene.spatial.util.ValueSourceFilter;
import org.apache.lucene.spatial.vector.DistanceValueSource;

public class PointVectorStrategy
extends SpatialStrategy {
    public static final String SUFFIX_X = "__x";
    public static final String SUFFIX_Y = "__y";
    private final String fieldNameX;
    private final String fieldNameY;
    public int precisionStep = 8;

    public PointVectorStrategy(SpatialContext ctx, String fieldNamePrefix) {
        super(ctx, fieldNamePrefix);
        this.fieldNameX = fieldNamePrefix + SUFFIX_X;
        this.fieldNameY = fieldNamePrefix + SUFFIX_Y;
    }

    public void setPrecisionStep(int p) {
        this.precisionStep = p;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
    }

    String getFieldNameX() {
        return this.fieldNameX;
    }

    String getFieldNameY() {
        return this.fieldNameY;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        if (shape instanceof Point) {
            return this.createIndexableFields((Point)shape);
        }
        throw new UnsupportedOperationException("Can only index Point, not " + shape);
    }

    public Field[] createIndexableFields(Point point) {
        FieldType doubleFieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
        doubleFieldType.setNumericPrecisionStep(this.precisionStep);
        Field[] f = new Field[]{new DoubleField(this.fieldNameX, point.getX(), doubleFieldType), new DoubleField(this.fieldNameY, point.getY(), doubleFieldType)};
        return f;
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceValueSource(this, queryPoint, multiplier);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        ConstantScoreQuery csq = this.makeQuery(args);
        Filter filter = csq.getFilter();
        if (filter != null) {
            return filter;
        }
        return new QueryWrapperFilter(csq.getQuery());
    }

    @Override
    public ConstantScoreQuery makeQuery(SpatialArgs args) {
        if (!SpatialOperation.is(args.getOperation(), SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        Shape shape = args.getShape();
        if (shape instanceof Rectangle) {
            Rectangle bbox = (Rectangle)shape;
            return new ConstantScoreQuery(this.makeWithin(bbox));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            Rectangle bbox = circle.getBoundingBox();
            ValueSourceFilter vsf = new ValueSourceFilter(new QueryWrapperFilter(this.makeWithin(bbox)), this.makeDistanceValueSource(circle.getCenter()), 0.0, circle.getRadius());
            return new ConstantScoreQuery(vsf);
        }
        throw new UnsupportedOperationException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
    }

    public Query makeQueryDistanceScore(SpatialArgs args) {
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle) && !(shape instanceof Circle)) {
            throw new UnsupportedOperationException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
        }
        Rectangle bbox = shape.getBoundingBox();
        if (bbox.getCrossesDateLine()) {
            throw new UnsupportedOperationException("Crossing dateline not yet supported");
        }
        ValueSource valueSource = null;
        Query spatial = null;
        SpatialOperation op = args.getOperation();
        if (SpatialOperation.is(op, SpatialOperation.BBoxWithin, SpatialOperation.BBoxIntersects)) {
            spatial = this.makeWithin(bbox);
        } else if (SpatialOperation.is(op, SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            spatial = this.makeWithin(bbox);
            if (args.getShape() instanceof Circle) {
                Circle circle = (Circle)args.getShape();
                valueSource = this.makeDistanceValueSource(shape.getCenter());
                ValueSourceFilter vsf = new ValueSourceFilter(new QueryWrapperFilter(spatial), valueSource, 0.0, circle.getRadius());
                spatial = new FilteredQuery(new MatchAllDocsQuery(), vsf);
            }
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox);
        }
        if (spatial == null) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        valueSource = valueSource != null ? new CachingDoubleValueSource(valueSource) : this.makeDistanceValueSource(shape.getCenter());
        FunctionQuery spatialRankingQuery = new FunctionQuery(valueSource);
        BooleanQuery bq = new BooleanQuery();
        bq.add(spatial, BooleanClause.Occur.MUST);
        bq.add(spatialRankingQuery, BooleanClause.Occur.MUST);
        return bq;
    }

    private Query makeWithin(Rectangle bbox) {
        BooleanQuery bq = new BooleanQuery();
        BooleanClause.Occur MUST = BooleanClause.Occur.MUST;
        if (bbox.getCrossesDateLine()) {
            bq.add(this.rangeQuery(this.fieldNameX, null, bbox.getMaxX()), BooleanClause.Occur.SHOULD);
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), null), BooleanClause.Occur.SHOULD);
            bq.setMinimumNumberShouldMatch(1);
        } else {
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), bbox.getMaxX()), MUST);
        }
        bq.add(this.rangeQuery(this.fieldNameY, bbox.getMinY(), bbox.getMaxY()), MUST);
        return bq;
    }

    private NumericRangeQuery<Double> rangeQuery(String fieldName, Double min2, Double max2) {
        return NumericRangeQuery.newDoubleRange(fieldName, this.precisionStep, min2, max2, true, true);
    }

    private Query makeDisjoint(Rectangle bbox) {
        if (bbox.getCrossesDateLine()) {
            throw new UnsupportedOperationException("makeDisjoint doesn't handle dateline cross");
        }
        NumericRangeQuery<Double> qX = this.rangeQuery(this.fieldNameX, bbox.getMinX(), bbox.getMaxX());
        NumericRangeQuery<Double> qY = this.rangeQuery(this.fieldNameY, bbox.getMinY(), bbox.getMaxY());
        BooleanQuery bq = new BooleanQuery();
        bq.add(qX, BooleanClause.Occur.MUST_NOT);
        bq.add(qY, BooleanClause.Occur.MUST_NOT);
        return bq;
    }
}

