/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash.format;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.HashFormatFactory;
import org.apache.shiro.crypto.hash.format.ProvidedHashFormat;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.util.UnknownClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHashFormatFactory
implements HashFormatFactory {
    private Map<String, String> formatClassNames;
    private Set<String> searchPackages = new HashSet<String>();

    public DefaultHashFormatFactory() {
        this.formatClassNames = new HashMap<String, String>();
    }

    public Map<String, String> getFormatClassNames() {
        return this.formatClassNames;
    }

    public void setFormatClassNames(Map<String, String> formatClassNames) {
        this.formatClassNames = formatClassNames;
    }

    public Set<String> getSearchPackages() {
        return this.searchPackages;
    }

    public void setSearchPackages(Set<String> searchPackages) {
        this.searchPackages = searchPackages;
    }

    @Override
    public HashFormat getInstance(String in) {
        if (in == null) {
            return null;
        }
        HashFormat hashFormat = null;
        Class clazz = null;
        if (in.startsWith("$")) {
            String possibleMcfId;
            String test = in.substring("$".length());
            String[] tokens2 = test.split("\\$");
            String string = possibleMcfId = tokens2 != null && tokens2.length > 0 ? tokens2[0] : null;
            if (possibleMcfId != null) {
                clazz = this.getHashFormatClass(possibleMcfId);
            }
        }
        if (clazz == null) {
            clazz = this.getHashFormatClass(in);
        }
        if (clazz != null) {
            hashFormat = this.newHashFormatInstance(clazz);
        }
        return hashFormat;
    }

    protected Class getHashFormatClass(String token) {
        ProvidedHashFormat provided;
        String value;
        Class clazz = null;
        if (this.formatClassNames != null && (value = this.formatClassNames.get(token)) != null) {
            clazz = this.lookupHashFormatClass(value);
        }
        if (clazz == null && (provided = ProvidedHashFormat.byId(token)) != null) {
            clazz = provided.getHashFormatClass();
        }
        if (clazz == null) {
            clazz = this.lookupHashFormatClass(token);
        }
        if (clazz == null && this.searchPackages != null) {
            String packageName;
            Iterator<String> i$ = this.searchPackages.iterator();
            while (i$.hasNext() && (clazz = this.getHashFormatClass(packageName = i$.next(), token)) == null) {
            }
        }
        if (clazz != null) {
            this.assertHashFormatImpl(clazz);
        }
        return clazz;
    }

    protected Class getHashFormatClass(String packageName, String token) {
        String test = token;
        Class clazz = null;
        String pkg = packageName == null ? "" : packageName;
        clazz = this.lookupHashFormatClass(test);
        if (clazz == null) {
            test = pkg + "." + token;
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + StringUtils.uppercaseFirstChar(token) + "Format";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + token + "Format";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + StringUtils.uppercaseFirstChar(token) + "HashFormat";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + token + "HashFormat";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + StringUtils.uppercaseFirstChar(token) + "CryptFormat";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            test = pkg + "." + token + "CryptFormat";
            clazz = this.lookupHashFormatClass(test);
        }
        if (clazz == null) {
            return null;
        }
        this.assertHashFormatImpl(clazz);
        return clazz;
    }

    protected Class lookupHashFormatClass(String name) {
        try {
            return ClassUtils.forName(name);
        }
        catch (UnknownClassException unknownClassException) {
            return null;
        }
    }

    protected final void assertHashFormatImpl(Class clazz) {
        if (!HashFormat.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            throw new IllegalArgumentException("Discovered class [" + clazz.getName() + "] is not a " + HashFormat.class.getName() + " implementation.");
        }
    }

    protected final HashFormat newHashFormatInstance(Class clazz) {
        this.assertHashFormatImpl(clazz);
        return (HashFormat)ClassUtils.newInstance(clazz);
    }
}

