/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.ldap.UnsupportedAuthenticationMechanismException;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLdapRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(JndiLdapRealm.class);
    private static final String USERDN_SUBSTITUTION_TOKEN = "{0}";
    private String userDnPrefix;
    private String userDnSuffix;
    private LdapContextFactory contextFactory;

    public JndiLdapRealm() {
        this.setCredentialsMatcher(new AllowAllCredentialsMatcher());
        this.setAuthenticationTokenClass(AuthenticationToken.class);
        this.contextFactory = new JndiLdapContextFactory();
    }

    protected String getUserDnPrefix() {
        return this.userDnPrefix;
    }

    protected String getUserDnSuffix() {
        return this.userDnSuffix;
    }

    public void setUserDnTemplate(String template) throws IllegalArgumentException {
        if (!StringUtils.hasText(template)) {
            String msg = "User DN template cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        int index = template.indexOf(USERDN_SUBSTITUTION_TOKEN);
        if (index < 0) {
            String msg = "User DN template must contain the '{0}' replacement token to understand where to insert the runtime authentication principal.";
            throw new IllegalArgumentException(msg);
        }
        String prefix = template.substring(0, index);
        String suffix = template.substring(prefix.length() + USERDN_SUBSTITUTION_TOKEN.length());
        if (log.isDebugEnabled()) {
            log.debug("Determined user DN prefix [{}] and suffix [{}]", (Object)prefix, (Object)suffix);
        }
        this.userDnPrefix = prefix;
        this.userDnSuffix = suffix;
    }

    public String getUserDnTemplate() {
        return this.getUserDn(USERDN_SUBSTITUTION_TOKEN);
    }

    protected String getUserDn(String principal) throws IllegalArgumentException, IllegalStateException {
        if (!StringUtils.hasText(principal)) {
            throw new IllegalArgumentException("User principal cannot be null or empty for User DN construction.");
        }
        String prefix = this.getUserDnPrefix();
        String suffix = this.getUserDnSuffix();
        if (prefix == null && suffix == null) {
            log.debug("userDnTemplate property has not been configured, indicating the submitted AuthenticationToken's principal is the same as the User DN.  Returning the method argument as is.");
            return principal;
        }
        int prefixLength = prefix != null ? prefix.length() : 0;
        int suffixLength = suffix != null ? suffix.length() : 0;
        StringBuilder sb = new StringBuilder(prefixLength + principal.length() + suffixLength);
        if (prefixLength > 0) {
            sb.append(prefix);
        }
        sb.append(principal);
        if (suffixLength > 0) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public void setContextFactory(LdapContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public LdapContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        try {
            info = this.queryForAuthenticationInfo(token, this.getContextFactory());
        }
        catch (AuthenticationNotSupportedException e2) {
            String msg = "Unsupported configured authentication mechanism";
            throw new UnsupportedAuthenticationMechanismException(msg, e2);
        }
        catch (javax.naming.AuthenticationException e3) {
            throw new AuthenticationException("LDAP authentication failed.", e3);
        }
        catch (NamingException e4) {
            String msg = "LDAP naming error while attempting to authenticate user.";
            throw new AuthenticationException(msg, e4);
        }
        return info;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthorizationInfo info;
        try {
            info = this.queryForAuthorizationInfo(principals, this.getContextFactory());
        }
        catch (NamingException e2) {
            String msg = "LDAP naming error while attempting to retrieve authorization for user [" + principals + "].";
            throw new AuthorizationException(msg, e2);
        }
        return info;
    }

    protected Object getLdapPrincipal(AuthenticationToken token) {
        Object principal = token.getPrincipal();
        if (principal instanceof String) {
            String sPrincipal = (String)principal;
            return this.getUserDn(sPrincipal);
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        AuthenticationInfo authenticationInfo;
        Object principal = token.getPrincipal();
        Object credentials = token.getCredentials();
        log.debug("Authenticating user '{}' through LDAP", principal);
        principal = this.getLdapPrincipal(token);
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getLdapContext(principal, credentials);
            authenticationInfo = this.createAuthenticationInfo(token, principal, credentials, ctx);
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext(ctx);
        return authenticationInfo;
    }

    protected AuthenticationInfo createAuthenticationInfo(AuthenticationToken token, Object ldapPrincipal, Object ldapCredentials, LdapContext ldapContext) throws NamingException {
        return new SimpleAuthenticationInfo(token.getPrincipal(), token.getCredentials(), this.getName());
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        return null;
    }
}

