/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import org.noggit.CharArr;

public class ByteUtils {
    public static int UTF8toUTF16(byte[] utf82, int offset, int len, char[] out, int out_offset) {
        int out_start = out_offset;
        int limit = offset + len;
        while (offset < limit) {
            int b;
            if ((b = utf82[offset++] & 0xFF) < 192) {
                assert (b < 128);
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf82[offset++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf82[offset] & 0x3F) << 6) + (utf82[offset + 1] & 0x3F));
                offset += 2;
                continue;
            }
            assert (b < 248);
            int ch = ((b & 7) << 18) + ((utf82[offset] & 0x3F) << 12) + ((utf82[offset + 1] & 0x3F) << 6) + (utf82[offset + 2] & 0x3F);
            offset += 3;
            if (ch < 65535) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            out[out_offset++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        return out_offset - out_start;
    }

    public static void UTF8toUTF16(byte[] utf82, int offset, int len, CharArr out) {
        out.reserve(len);
        int n = ByteUtils.UTF8toUTF16(utf82, offset, len, out.getArray(), out.getEnd());
        out.setEnd(out.getEnd() + n);
    }

    public static String UTF8toUTF16(byte[] utf82, int offset, int len) {
        char[] out = new char[len];
        int n = ByteUtils.UTF8toUTF16(utf82, offset, len, out, 0);
        return new String(out, 0, n);
    }

    public static int UTF16toUTF8(CharSequence s, int offset, int len, byte[] result, int resultOffset) {
        int end = offset + len;
        int upto = resultOffset;
        for (int i = offset; i < end; ++i) {
            int utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                result[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                result[upto++] = (byte)(0xC0 | code >> 6);
                result[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                result[upto++] = (byte)(0xE0 | code >> 12);
                result[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                result[upto++] = (byte)(0xF0 | utf32 >> 18);
                result[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            result[upto++] = -17;
            result[upto++] = -65;
            result[upto++] = -67;
        }
        return upto - resultOffset;
    }
}

