/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final HashMap<String, HashSet<Watcher>> watchTable = new HashMap();
    private final HashMap<Watcher, HashSet<String>> watch2Paths = new HashMap();

    public synchronized int size() {
        int result = 0;
        for (HashSet<Watcher> watches : this.watchTable.values()) {
            result += watches.size();
        }
        return result;
    }

    public synchronized void addWatch(String path, Watcher watcher) {
        HashSet<Watcher> list = this.watchTable.get(path);
        if (list == null) {
            list = new HashSet(4);
            this.watchTable.put(path, list);
        }
        list.add(watcher);
        HashSet<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet();
            this.watch2Paths.put(watcher, paths);
        }
        paths.add(path);
    }

    public synchronized void removeWatcher(Watcher watcher) {
        HashSet<String> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p : paths) {
            HashSet<Watcher> list = this.watchTable.get(p);
            if (list == null) continue;
            list.remove(watcher);
            if (list.size() != 0) continue;
            this.watchTable.remove(p);
        }
    }

    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type) {
        return this.triggerWatch(path, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type, Set<Watcher> supress) {
        HashSet<Watcher> watchers;
        WatchedEvent e2 = new WatchedEvent(type, Watcher.Event.KeeperState.SyncConnected, path);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            watchers = this.watchTable.remove(path);
            if (watchers == null || watchers.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path);
                }
                return null;
            }
            for (Watcher w : watchers) {
                HashSet<String> paths = this.watch2Paths.get(w);
                if (paths == null) continue;
                paths.remove(path);
            }
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            w.process(e2);
        }
        return watchers;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total = 0;
        for (HashSet<String> paths : this.watch2Paths.values()) {
            total += paths.size();
        }
        sb.append("Total watches:").append(total);
        return sb.toString();
    }

    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, HashSet<Watcher>> e2 : this.watchTable.entrySet()) {
                pwriter.println(e2.getKey());
                for (Watcher w : e2.getValue()) {
                    pwriter.print("\t0x");
                    pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                    pwriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, HashSet<String>> e3 : this.watch2Paths.entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e3.getKey()).getSessionId()));
                for (String path : e3.getValue()) {
                    pwriter.print("\t");
                    pwriter.println(path);
                }
            }
        }
    }
}

