/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.xml.XmlParser;

public class WebDescriptor
extends Descriptor {
    private static final Logger LOG = Log.getLogger(WebDescriptor.class);
    protected static XmlParser _parserSingleton;
    protected MetaDataComplete _metaDataComplete;
    protected int _majorVersion = 3;
    protected int _minorVersion = 0;
    protected ArrayList<String> _classNames = new ArrayList();
    protected boolean _distributable;
    protected boolean _isOrdered = false;
    protected List<String> _ordering = new ArrayList<String>();

    @Override
    public void ensureParser() throws ClassNotFoundException {
        if (_parserSingleton == null) {
            _parserSingleton = this.newParser();
        }
        this._parser = _parserSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlParser newParser() throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_2.dtd");
        URL dtd23 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_3.dtd");
        URL j2ee14xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_1_4.xsd");
        URL javaee5 = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_5.xsd");
        URL javaee6 = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_6.xsd");
        URL javaee7 = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_7.xsd");
        URL webapp24xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_4.xsd");
        URL webapp25xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_5.xsd");
        URL webapp30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_3_0.xsd");
        URL webcommon30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-common_3_0.xsd");
        URL webfragment30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-fragment_3_0.xsd");
        URL webapp31xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_3_1.xsd");
        URL webcommon31xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-common_3_1.xsd");
        URL webfragment31xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-fragment_3_1.xsd");
        URL schemadtd = Loader.getResource(Servlet.class, "javax/servlet/resources/XMLSchema.dtd");
        URL xmlxsd = Loader.getResource(Servlet.class, "javax/servlet/resources/xml.xsd");
        URL webservice11xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL webservice12xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_2.xsd");
        URL webservice13xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_3.xsd");
        URL webservice14xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_4.xsd");
        URL datatypesdtd = Loader.getResource(Servlet.class, "javax/servlet/resources/datatypes.dtd");
        URL jsp20xsd = null;
        URL jsp21xsd = null;
        URL jsp22xsd = null;
        URL jsp23xsd = null;
        try {
            jsp20xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_0.xsd");
            jsp21xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_1.xsd");
            jsp22xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_2.xsd");
            jsp23xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_3.xsd");
        }
        catch (Exception e2) {
            LOG.ignore(e2);
        }
        finally {
            if (jsp20xsd == null) {
                jsp20xsd = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/jsp_2_0.xsd");
            }
            if (jsp21xsd == null) {
                jsp21xsd = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/jsp_2_1.xsd");
            }
            if (jsp22xsd == null) {
                jsp22xsd = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/jsp_2_2.xsd");
            }
            if (jsp23xsd == null) {
                jsp23xsd = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/jsp_2_3.xsd");
            }
        }
        this.redirect(xmlParser, "web-app_2_2.dtd", dtd22);
        this.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        this.redirect(xmlParser, "web.dtd", dtd23);
        this.redirect(xmlParser, "web-app_2_3.dtd", dtd23);
        this.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        this.redirect(xmlParser, "XMLSchema.dtd", schemadtd);
        this.redirect(xmlParser, "http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        this.redirect(xmlParser, "-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        this.redirect(xmlParser, "jsp_2_0.xsd", jsp20xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        this.redirect(xmlParser, "jsp_2_2.xsd", jsp22xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_2.xsd", jsp22xsd);
        this.redirect(xmlParser, "jsp_2_3.xsd", jsp23xsd);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/jsp_2_3.xsd", jsp23xsd);
        this.redirect(xmlParser, "j2ee_1_4.xsd", j2ee14xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/javaee_5.xsd", javaee5);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/javaee_6.xsd", javaee6);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/javaee_7.xsd", javaee7);
        this.redirect(xmlParser, "web-app_2_4.xsd", webapp24xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        this.redirect(xmlParser, "web-app_2_5.xsd", webapp25xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        this.redirect(xmlParser, "web-app_3_0.xsd", webapp30xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
        this.redirect(xmlParser, "web-common_3_0.xsd", webcommon30xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-common_3_0.xsd", webcommon30xsd);
        this.redirect(xmlParser, "web-fragment_3_0.xsd", webfragment30xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", webfragment30xsd);
        this.redirect(xmlParser, "web-app_3_1.xsd", webapp31xsd);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", webapp31xsd);
        this.redirect(xmlParser, "web-common_3_1.xsd", webcommon30xsd);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/web-common_3_1.xsd", webcommon31xsd);
        this.redirect(xmlParser, "web-fragment_3_1.xsd", webfragment30xsd);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/web-fragment_3_1.xsd", webfragment31xsd);
        this.redirect(xmlParser, "xml.xsd", xmlxsd);
        this.redirect(xmlParser, "http://www.w3.org/2001/xml.xsd", xmlxsd);
        this.redirect(xmlParser, "datatypes.dtd", datatypesdtd);
        this.redirect(xmlParser, "http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        this.redirect(xmlParser, "j2ee_web_services_client_1_1.xsd", webservice11xsd);
        this.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        this.redirect(xmlParser, "javaee_web_services_client_1_2.xsd", webservice12xsd);
        this.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        this.redirect(xmlParser, "javaee_web_services_client_1_3.xsd", webservice13xsd);
        this.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/javaee_web_services_client_1_3.xsd", webservice13xsd);
        this.redirect(xmlParser, "javaee_web_services_client_1_4.xsd", webservice14xsd);
        this.redirect(xmlParser, "http://xmlns.jcp.org/xml/ns/javaee/javaee_web_services_client_1_4.xsd", webservice14xsd);
        return xmlParser;
    }

    public WebDescriptor(Resource xml) {
        super(xml);
    }

    @Override
    public void parse() throws Exception {
        super.parse();
        this.processVersion();
        this.processOrdering();
    }

    public MetaDataComplete getMetaDataComplete() {
        return this._metaDataComplete;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void processVersion() {
        String version2 = this._root.getAttribute("version", "DTD");
        if ("DTD".equals(version2)) {
            this._majorVersion = 2;
            this._minorVersion = 3;
            String dtd = this._parser.getDTD();
            if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                this._majorVersion = 2;
                this._minorVersion = 2;
            }
        } else {
            int dot = version2.indexOf(".");
            if (dot > 0) {
                this._majorVersion = Integer.parseInt(version2.substring(0, dot));
                this._minorVersion = Integer.parseInt(version2.substring(dot + 1));
            }
        }
        if (this._majorVersion < 2 && this._minorVersion < 5) {
            this._metaDataComplete = MetaDataComplete.True;
        } else {
            String s = this._root.getAttribute("metadata-complete");
            if (s == null) {
                this._metaDataComplete = MetaDataComplete.NotSet;
            } else {
                MetaDataComplete metaDataComplete = this._metaDataComplete = Boolean.valueOf(s) != false ? MetaDataComplete.True : MetaDataComplete.False;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._xml.toString() + ": Calculated metadatacomplete = " + (Object)((Object)this._metaDataComplete) + " with version=" + version2, new Object[0]);
        }
    }

    public void processOrdering() {
        XmlParser.Node ordering = this._root.get("absolute-ordering");
        if (ordering == null) {
            return;
        }
        this._isOrdered = true;
        Iterator iter = ordering.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            if (node.getTag().equalsIgnoreCase("others")) {
                this._ordering.add("others");
                continue;
            }
            if (!node.getTag().equalsIgnoreCase("name")) continue;
            this._ordering.add(node.toString(false, true));
        }
    }

    public void addClassName(String className) {
        if (!this._classNames.contains(className)) {
            this._classNames.add(className);
        }
    }

    public ArrayList<String> getClassNames() {
        return this._classNames;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    @Override
    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public boolean isOrdered() {
        return this._isOrdered;
    }

    public List<String> getOrdering() {
        return this._ordering;
    }
}

