/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.io.File;
import java.io.InputStream;
import java.net.BindException;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.ManagementServer;
import org.apache.jena.fuseki.server.FusekiConfig;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.apache.jena.fuseki.server.ServerConfig;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;

public class FusekiCmd
extends CmdARQ {
    private static String log4Jsetup = StrUtils.strjoinNL((String[])new String[]{"## Plain output to stdout", "log4j.appender.jena.plain=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plain.target=System.out", "log4j.appender.jena.plain.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plain.layout.ConversionPattern=%d{HH:mm:ss} %-5p %m%n", "## Plain output with level, to stderr", "log4j.appender.jena.plainlevel=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plainlevel.target=System.err", "log4j.appender.jena.plainlevel.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plainlevel.layout.ConversionPattern=%d{HH:mm:ss} %-5p %m%n", "## Everything", "log4j.rootLogger=INFO, jena.plain", "log4j.logger.com.hp.hpl.jena=WARN", "log4j.logger.org.openjena=WARN", "log4j.logger.org.apache.jena=WARN", "# Server log.", "log4j.logger.org.apache.jena.fuseki.Server=INFO", "# Request log.", "log4j.logger.org.apache.jena.fuseki.Fuseki=INFO", "log4j.logger.org.apache.jena.tdb.loader=INFO", "log4j.logger.org.eclipse.jetty=ERROR", "## Parser output", "log4j.additivity.org.apache.jena.riot=false", "log4j.logger.org.apache.jena.riot=INFO, jena.plainlevel "});
    private static ArgDecl argMgtPort;
    private static ArgDecl argMem;
    private static ArgDecl argAllowUpdate;
    private static ArgDecl argFile;
    private static ArgDecl argMemTDB;
    private static ArgDecl argTDB;
    private static ArgDecl argPort;
    private static ArgDecl argLocalhost;
    private static ArgDecl argTimeout;
    private static ArgDecl argFusekiConfig;
    private static ArgDecl argJettyConfig;
    private static ArgDecl argGZip;
    private static ArgDecl argUber;
    private static ArgDecl argBasicAuth;
    private static ArgDecl argGSP;
    private static ArgDecl argHome;
    private static ArgDecl argPages;
    private static ModDatasetAssembler modDataset;
    private int port = 3030;
    private int mgtPort = -1;
    private boolean listenLocal = false;
    private DatasetGraph dsg = null;
    private String datasetPath = null;
    private boolean allowUpdate = false;
    private String fusekiConfigFile = null;
    private boolean enableCompression = true;
    private String jettyConfigFile = null;
    private String authConfigFile = null;
    private String homeDir = null;
    private String pagesDir = null;
    static String argUsage;

    static void setLogging() {
        String x = System.getProperty("log4j.configuration", null);
        if (x != null && !x.equals("set")) {
            return;
        }
        String fn = "log4j.properties";
        File f = new File(fn);
        if (f.exists()) {
            System.setProperty("log4j.configuration", "file:" + fn);
            return;
        }
        LogCtl.resetLogging((String)log4Jsetup);
    }

    public static void main(String ... argv) {
        ARQ.init();
        TDB.init();
        Fuseki.init();
        new FusekiCmd(argv).mainRun();
    }

    public FusekiCmd(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Fuseki");
        this.addModule((ArgModuleGeneral)modDataset);
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argPort, "--port", "Listen on this port number");
        this.add(argPages, "--pages=DIR", "Set of pages to serve as static content");
        this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
        this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argAllowUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.add(argFusekiConfig, "--config=", "Use a configuration file to determine the services");
        this.add(argJettyConfig, "--jetty-config=FILE", "Set up the server (not services) with a Jetty XML file");
        this.add(argBasicAuth, "--basic-auth=FILE", "Configure basic auth using provided Jetty realm file, ignored if --jetty-config is used");
        this.add(argMgtPort, "--mgtPort=port", "Enable the management commands on the given port");
        this.add(argHome, "--home=DIR", "Root of Fuseki installation (overrides environment variable FUSEKI_HOME)");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.add(argUber);
        this.modVersion.addClass(TDB.class);
        this.modVersion.addClass(Fuseki.class);
    }

    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    protected void processModulesAndArgs() {
        List args;
        int x = 0;
        Logger log = Fuseki.serverLog;
        if (this.contains(argFusekiConfig)) {
            this.fusekiConfigFile = this.getValue(argFusekiConfig);
        }
        ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", new String[]{"dataset"});
        if (this.contains(argMem)) {
            ++x;
        }
        if (this.contains(argFile)) {
            ++x;
        }
        if (this.contains(assemblerDescDecl)) {
            ++x;
        }
        if (this.contains(argTDB)) {
            ++x;
        }
        if (this.contains(argMemTDB)) {
            ++x;
        }
        if (this.fusekiConfigFile != null) {
            if (x >= 1) {
                throw new CmdException("Dataset specified on the command line but a configuration file also given.");
            }
        } else if (x != 1) {
            throw new CmdException("Required: either --config=FILE or one of --mem, --file, --loc or --desc");
        }
        if (this.contains(argMem)) {
            log.info("Dataset: in-memory");
            this.dsg = DatasetGraphFactory.createMem();
        }
        if (this.contains(argFile)) {
            this.dsg = DatasetGraphFactory.createMem();
            String filename = this.getValue(argFile);
            log.info("Dataset: in-memory: load file: " + filename);
            if (!FileOps.exists((String)filename)) {
                throw new CmdException("File not found: " + filename);
            }
            Lang language = RDFLanguages.filenameToLang((String)filename);
            if (language == null) {
                throw new CmdException("Can't guess language for file: " + filename);
            }
            InputStream input = IO.openFile((String)filename);
            if (RDFLanguages.isQuads((Lang)language)) {
                RDFDataMgr.read((DatasetGraph)this.dsg, (String)filename);
            } else {
                RDFDataMgr.read((Graph)this.dsg.getDefaultGraph(), (String)filename);
            }
        }
        if (this.contains(argMemTDB)) {
            log.info("TDB dataset: in-memory");
            this.dsg = TDBFactory.createDatasetGraph();
        }
        if (this.contains(argTDB)) {
            String dir = this.getValue(argTDB);
            if (Lib.equal((Object)dir, (Object)"--mem--")) {
                log.info("TDB dataset: in-memory");
            } else {
                if (!FileOps.exists((String)dir)) {
                    throw new CmdException("Directory not found: " + dir);
                }
                log.info("TDB dataset: directory=" + dir);
            }
            this.dsg = TDBFactory.createDatasetGraph((String)dir);
        }
        if (this.contains(assemblerDescDecl)) {
            log.info("Dataset from assembler");
            Dataset ds = modDataset.createDataset();
            if (ds != null) {
                this.dsg = ds.asDatasetGraph();
            }
        }
        if (this.contains(argFusekiConfig)) {
            if (this.dsg != null) {
                throw new CmdException("(internal error) Dataset specificed on the command line but a a configuration file also given.");
            }
            this.fusekiConfigFile = this.getValue(argFusekiConfig);
        }
        if (this.contains(argPort)) {
            String portStr = this.getValue(argPort);
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
            }
        }
        if (this.contains(argMgtPort)) {
            String mgtPortStr = this.getValue(argMgtPort);
            try {
                this.mgtPort = Integer.parseInt(mgtPortStr);
            }
            catch (NumberFormatException ex) {
                throw new CmdException(argMgtPort.getKeyName() + " : bad port number: " + mgtPortStr);
            }
        }
        if (this.contains(argLocalhost)) {
            this.listenLocal = true;
        }
        if (this.fusekiConfigFile == null && this.dsg == null) {
            throw new CmdException("No dataset defined and no configuration file: " + argUsage);
        }
        if (this.dsg != null) {
            if (this.getPositional().size() == 0) {
                throw new CmdException("No dataset path name given");
            }
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            this.datasetPath = this.getPositionalArg(0);
            if (this.datasetPath.length() > 0 && !this.datasetPath.startsWith("/")) {
                throw new CmdException("Dataset path name must begin with a /: " + this.datasetPath);
            }
            this.allowUpdate = this.contains(argAllowUpdate);
        }
        if (this.contains(argTimeout)) {
            String str = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, (Object)str);
        }
        if (this.contains(argJettyConfig)) {
            this.jettyConfigFile = this.getValue(argJettyConfig);
            if (!FileOps.exists((String)this.jettyConfigFile)) {
                throw new CmdException("No such file: " + this.jettyConfigFile);
            }
        }
        if (this.contains(argBasicAuth)) {
            this.authConfigFile = this.getValue(argBasicAuth);
            if (!FileOps.exists((String)this.authConfigFile)) {
                throw new CmdException("No such file: " + this.authConfigFile);
            }
        }
        if (this.contains(argHome)) {
            args = super.getValues(argHome);
            this.homeDir = (String)args.get(args.size() - 1);
        }
        if (this.contains(argPages)) {
            args = super.getValues(argPages);
            this.pagesDir = (String)args.get(args.size() - 1);
        }
        if (this.contains(argGZip)) {
            if (!this.hasValueOfTrue(argGZip) && !this.hasValueOfFalse(argGZip)) {
                throw new CmdException((String)argGZip.getNames().get(0) + ": Not understood: " + this.getValue(argGZip));
            }
            this.enableCompression = super.hasValueOfTrue(argGZip);
        }
        if (this.contains(argUber)) {
            SPARQLServer.\u00fcberServlet = true;
        }
        if (this.contains(argGSP)) {
            SPARQLServer.\u00fcberServlet = true;
            Fuseki.graphStoreProtocolPostCreate = true;
        }
    }

    private static String sort_out_dir(String path) {
        path.replace('\\', '/');
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    protected void exec() {
        ServerConfig serverConfig;
        String staticContentDir;
        if (this.homeDir == null) {
            this.homeDir = System.getenv(Fuseki.FusekiHomeEnv) != null ? System.getenv(Fuseki.FusekiHomeEnv) : ".";
        }
        this.homeDir = FusekiCmd.sort_out_dir(this.homeDir);
        Fuseki.configLog.info("Home Directory: " + FileOps.fullDirectoryPath((String)this.homeDir));
        if (!FileOps.exists((String)this.homeDir)) {
            Fuseki.configLog.warn("No such directory for Fuseki home: " + this.homeDir);
        }
        if ((staticContentDir = this.pagesDir) == null) {
            staticContentDir = this.homeDir + Fuseki.PagesStatic;
        }
        Fuseki.configLog.debug("Static Content Directory: " + FileOps.fullDirectoryPath((String)staticContentDir));
        if (!FileOps.exists((String)staticContentDir)) {
            Fuseki.configLog.warn("No such directory for static content: " + FileOps.fullDirectoryPath((String)staticContentDir));
            Fuseki.configLog.warn("You may need to set the --pages or --home option to configure static content correctly");
        }
        if (this.jettyConfigFile != null) {
            Fuseki.configLog.info("Jetty configuration: " + this.jettyConfigFile);
        }
        if (this.fusekiConfigFile != null) {
            Fuseki.configLog.info("Configuration file: " + this.fusekiConfigFile);
            serverConfig = FusekiConfig.configure(this.fusekiConfigFile);
        } else {
            serverConfig = FusekiConfig.defaultConfiguration(this.datasetPath, this.dsg, this.allowUpdate, this.listenLocal);
            if (!this.allowUpdate) {
                Fuseki.serverLog.info("Running in read-only mode.");
            }
        }
        serverConfig.port = this.port;
        serverConfig.pages = staticContentDir;
        serverConfig.mgtPort = this.mgtPort;
        serverConfig.pagesPort = this.port;
        serverConfig.loopback = this.listenLocal;
        serverConfig.enableCompression = this.enableCompression;
        serverConfig.jettyConfigFile = this.jettyConfigFile;
        serverConfig.authConfigFile = this.authConfigFile;
        serverConfig.verboseLogging = super.isVerbose() || super.isDebug();
        SPARQLServer server = new SPARQLServer(serverConfig);
        Fuseki.setServer(server);
        Server mgtServer = null;
        if (this.mgtPort > 0) {
            Fuseki.configLog.info("Management services on port " + this.mgtPort);
            mgtServer = ManagementServer.createManagementServer(this.mgtPort);
            try {
                mgtServer.start();
            }
            catch (BindException ex) {
                Fuseki.serverLog.error("SPARQLServer: Failed to start management server: " + ex.getMessage());
                System.exit(1);
            }
            catch (Exception ex) {
                Fuseki.serverLog.error("SPARQLServer: Failed to start management server: " + ex.getMessage(), (Throwable)ex);
                System.exit(1);
            }
        }
        server.start();
        try {
            server.getServer().join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (mgtServer != null) {
            try {
                mgtServer.stop();
            }
            catch (Exception e) {
                Fuseki.serverLog.warn("Failed to cleanly stop the management server", (Throwable)e);
            }
        }
        System.exit(0);
    }

    protected String getCommandName() {
        return "fuseki";
    }

    static {
        FusekiCmd.setLogging();
        argMgtPort = new ArgDecl(true, "mgtPort", new String[]{"mgtport"});
        argMem = new ArgDecl(false, "mem", new String[0]);
        argAllowUpdate = new ArgDecl(false, "update", new String[]{"allowUpdate"});
        argFile = new ArgDecl(true, "file", new String[0]);
        argMemTDB = new ArgDecl(false, "memtdb", new String[]{"memTDB"});
        argTDB = new ArgDecl(true, "loc", new String[]{"location"});
        argPort = new ArgDecl(true, "port", new String[0]);
        argLocalhost = new ArgDecl(false, "localhost", new String[]{"local"});
        argTimeout = new ArgDecl(true, "timeout", new String[0]);
        argFusekiConfig = new ArgDecl(true, "config", new String[]{"conf"});
        argJettyConfig = new ArgDecl(true, "jetty-config", new String[0]);
        argGZip = new ArgDecl(true, "gzip", new String[0]);
        argUber = new ArgDecl(false, "uber", new String[]{"\u00fcber"});
        argBasicAuth = new ArgDecl(true, "basic-auth", new String[0]);
        argGSP = new ArgDecl(false, "gsp", new String[0]);
        argHome = new ArgDecl(true, "home", new String[0]);
        argPages = new ArgDecl(true, "pages", new String[0]);
        modDataset = new ModDatasetAssembler();
        argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";
    }
}

