/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.server.ServiceRef;

public class MgtFunctions {
    public static String dataset(HttpServletRequest request, String dftValue) {
        String ds = MgtFunctions.dataset(request);
        if (ds == null) {
            return dftValue;
        }
        return ds;
    }

    public static String dataset(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return "No session";
        }
        String ds = (String)session.getAttribute("dataset");
        return ds;
    }

    public static DatasetRef datasetDesc(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String ds = (String)session.getAttribute("dataset");
        return (DatasetRef)DatasetRegistry.get().get(ds);
    }

    public static List<String> datasets(HttpServletRequest request) {
        return Iter.toList(DatasetRegistry.get().keys());
    }

    public static String actionDataset(HttpServletRequest request) {
        return "/$/datasets";
    }

    public static String serviceQuery(String dataset) {
        String dft = "sparql";
        DatasetRef ref = MgtFunctions.getFromRegistry(dataset);
        if (ref == null) {
            return dft;
        }
        return MgtFunctions.serviceNameOrDefault(ref.query, dft);
    }

    public static String serviceUpdate(String dataset) {
        String dft = "update";
        DatasetRef ref = MgtFunctions.getFromRegistry(dataset);
        if (ref == null) {
            return dft;
        }
        return MgtFunctions.serviceNameOrDefault(ref.update, dft);
    }

    public static String serviceUpload(String dataset) {
        String dft = "upload";
        DatasetRef ref = MgtFunctions.getFromRegistry(dataset);
        if (ref == null) {
            return dft;
        }
        return MgtFunctions.serviceNameOrDefault(ref.upload, dft);
    }

    public static String serviceGraphRead(String dataset) {
        String dft = "get";
        DatasetRef ref = MgtFunctions.getFromRegistry(dataset);
        if (ref == null) {
            return dft;
        }
        return MgtFunctions.serviceNameOrDefault(ref.readGraphStore, dft);
    }

    public static String serviceGraphReadWrite(String dataset) {
        String dft = "data";
        DatasetRef ref = MgtFunctions.getFromRegistry(dataset);
        if (ref == null) {
            return dft;
        }
        return MgtFunctions.serviceNameOrDefault(ref.readWriteGraphStore, dft);
    }

    private static DatasetRef getFromRegistry(String dataset) {
        DatasetRegistry registry = DatasetRegistry.get();
        if (registry == null) {
            Fuseki.serverLog.warn("No dataset registry");
            return null;
        }
        DatasetRef ref = (DatasetRef)registry.get(dataset);
        if (ref == null) {
            Fuseki.serverLog.warn("Dataset not found: " + dataset);
        }
        return ref;
    }

    private static String serviceNameOrDefault(ServiceRef service, String defaultValue) {
        if (service.endpoints.isEmpty()) {
            return defaultValue;
        }
        String x = service.endpoints.get(0);
        if (x.startsWith("/")) {
            x = x.substring(1);
        }
        return x;
    }

    public static String prefixes(HttpServletRequest request) {
        String dsName = MgtFunctions.dataset(request);
        DatasetRef desc = MgtFunctions.getFromRegistry(dsName);
        if (desc == null) {
            return "<not found>";
        }
        DatasetGraph dsg = desc.dataset;
        if (dsg instanceof DatasetGraphTDB) {
            PrefixMapping pmap = ((DatasetGraphTDB)dsg).getPrefixes().getPrefixMapping();
            Prologue prologue = new Prologue(pmap);
            IndentedLineBuffer buff = new IndentedLineBuffer();
            PrologueSerializer.output((IndentedWriter)buff, (Prologue)prologue);
            buff.append("\n", new Object[0]);
            return buff.asString();
        }
        return "";
    }
}

