/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;

public class SPARQL_REST_R
extends SPARQL_REST {
    @Override
    protected String mapRequestToDataset(String uri) {
        return SPARQL_REST_R.mapRequestToDatasetLongest$(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpAction action) {
        ServletOutputStream output;
        MediaType mediaType = HttpAction.contentNegotationRDF(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            SPARQL_REST_R.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream((OutputStream)output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.getContentType());
        if (action.verbose) {
            log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        action.beginRead();
        SPARQL_REST_R.setCommonHeaders((HttpServletResponse)action.response);
        try {
            boolean exists;
            SPARQL_REST.Target target = SPARQL_REST_R.determineTarget(action);
            if (log.isDebugEnabled()) {
                log.debug("GET->" + target);
            }
            if (!(exists = target.exists())) {
                SPARQL_REST_R.errorNotFound("No such graph: <" + target.name + ">");
            }
            String ct = lang.getContentType().toHeaderString();
            action.response.setContentType(ct);
            Graph g = target.graph();
            RDFFormat fmt = lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization((Lang)lang);
            RDFDataMgr.write((OutputStream)out, (Graph)g, (RDFFormat)fmt);
            SPARQL_REST_R.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        SPARQL_REST_R.setCommonHeadersForOptions((HttpServletResponse)action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
        action.response.setHeader("Content-Length", "0");
        SPARQL_REST_R.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(HttpAction action) {
        SPARQL_REST_R.setCommonHeaders((HttpServletResponse)action.response);
        action.beginRead();
        try {
            SPARQL_REST.Target target = SPARQL_REST_R.determineTarget(action);
            if (log.isDebugEnabled()) {
                log.debug("HEAD->" + target);
            }
            if (!target.exists()) {
                SPARQL_REST_R.successNotFound(action);
                return;
            }
            MediaType mediaType = HttpAction.contentNegotationRDF(action);
            SPARQL_REST_R.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        SPARQL_REST_R.errorMethodNotAllowed("POST");
    }

    @Override
    protected void doDelete(HttpAction action) {
        SPARQL_REST_R.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(HttpAction action) {
        SPARQL_REST_R.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(HttpAction action) {
        SPARQL_REST_R.errorMethodNotAllowed("PATCH");
    }
}

