/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintDataTerm;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ClassConstraint
extends ConstraintDataTerm {
    private final Node expectedClass;

    public ClassConstraint(Node expectedClass) {
        this.expectedClass = expectedClass;
    }

    public Node getExpectedClass() {
        return this.expectedClass;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Graph data, Node focusNode) {
        if (focusNode.isLiteral()) {
            String msg = this.toString() + ": Expected class :" + ShLib.displayStr(this.expectedClass) + " for " + ShLib.displayStr(focusNode);
            return new ReportItem(msg, focusNode);
        }
        List<Node> types = G.listAllTypesOfNode(data, focusNode);
        if (types.contains(this.expectedClass)) {
            return null;
        }
        String msg = this.toString() + ": Expected class :" + ShLib.displayStr(this.expectedClass) + " for " + ShLib.displayStr(focusNode);
        return new ReportItem(msg, focusNode);
    }

    @Override
    public Node getComponent() {
        return SHACL.ClassConstraintComponent;
    }

    public String toString() {
        return "ClassConstraint[" + ShLib.displayStr(this.expectedClass) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.expectedClass);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassConstraint)) {
            return false;
        }
        ClassConstraint other = (ClassConstraint)obj;
        return Objects.equals(this.expectedClass, other.expectedClass);
    }
}

