/*
 * Decompiled with CFR 0.152.
 */
package jena;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import org.apache.jena.query.spatial.DatasetGraphSpatial;
import org.apache.jena.query.spatial.SpatialDatasetFactory;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexContext;
import org.apache.jena.query.spatial.SpatialQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class spatialindexer
extends CmdARQ {
    private static Logger log = LoggerFactory.getLogger(spatialindexer.class);
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", new String[]{"dataset"});
    protected DatasetGraphSpatial dataset = null;
    protected SpatialIndex spatialIndex = null;
    protected SpatialIndexContext context = null;
    protected ProgressMonitor progressMonitor;

    public static void main(String ... argv) {
        SpatialQuery.init();
        new spatialindexer(argv).mainRun();
    }

    public static void testMain(String ... argv) {
        new spatialindexer(argv).mainMethod();
    }

    protected spatialindexer(String[] argv) {
        super(argv);
        super.add(assemblerDescDecl, "--desc=", "Assembler description file");
        this.progressMonitor = new ProgressMonitor("properties indexed");
    }

    protected void processModulesAndArgs() {
        String file;
        super.processModulesAndArgs();
        if (super.contains(assemblerDescDecl)) {
            if (this.getValues(assemblerDescDecl).size() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            if (this.getPositional().size() != 0) {
                throw new CmdException("Additional assembler descriptions given");
            }
            file = this.getValue(assemblerDescDecl);
        } else {
            if (this.getNumPositional() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            file = this.getPositionalArg(0);
        }
        if (file == null) {
            throw new CmdException("No dataset specified");
        }
        Dataset ds = SpatialDatasetFactory.create(file);
        if (ds == null) {
            throw new CmdException("No dataset description found");
        }
        this.dataset = (DatasetGraphSpatial)ds.asDatasetGraph();
        this.spatialIndex = this.dataset.getSpatialIndex();
        if (this.spatialIndex == null) {
            throw new CmdException("Dataset has no spatial index");
        }
        this.context = new SpatialIndexContext(this.spatialIndex);
    }

    protected String getSummary() {
        return this.getCommandName() + " assemblerFile";
    }

    protected void exec() {
        this.spatialIndex.startIndexing();
        Iterator quadIter = this.dataset.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        while (quadIter.hasNext()) {
            Quad quad = (Quad)quadIter.next();
            this.context.index(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            this.progressMonitor.progressByOne();
        }
        this.spatialIndex.finishIndexing();
        this.progressMonitor.close();
    }

    private static class ProgressMonitor {
        String progressMessage;
        long startTime;
        long progressCount;
        long intervalStartTime;
        long progressAtStartOfInterval;
        long reportingInterval = 10000L;

        ProgressMonitor(String progressMessage) {
            this.progressMessage = progressMessage;
            this.start();
        }

        void start() {
            this.startTime = System.currentTimeMillis();
            this.progressCount = 0L;
            this.startInterval();
        }

        private void startInterval() {
            this.intervalStartTime = System.currentTimeMillis();
            this.progressAtStartOfInterval = this.progressCount;
        }

        void progressByOne() {
            ++this.progressCount;
            long now = System.currentTimeMillis();
            if (this.reportDue(now)) {
                this.report(now);
                this.startInterval();
            }
        }

        boolean reportDue(long now) {
            return now - this.intervalStartTime >= this.reportingInterval;
        }

        private void report(long now) {
            long progressThisInterval = this.progressCount - this.progressAtStartOfInterval;
            long intervalDuration = now - this.intervalStartTime;
            long overallDuration = now - this.startTime;
            String message = this.progressCount + " (" + progressThisInterval / (intervalDuration / 1000L) + " per second)" + this.progressMessage + " (" + this.progressCount / Math.max(overallDuration / 1000L, 1L) + " per second overall)";
            log.info(message);
        }

        void close() {
            long overallDuration = System.currentTimeMillis() - this.startTime;
            String message = this.progressCount + " (" + this.progressCount / Math.max(overallDuration / 1000L, 1L) + " per second) " + this.progressMessage;
            log.info(message);
        }
    }
}

