/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMonitor;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Transactional;
import org.apache.jena.query.spatial.SpatialDocProducer;
import org.apache.jena.query.spatial.SpatialIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphSpatial
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphSpatial.class);
    private final SpatialIndex spatialIndex;
    private final Transactional dsgtxn;
    private boolean needFinish = false;

    public DatasetGraphSpatial(DatasetGraph dsg, SpatialIndex index, SpatialDocProducer producer) {
        super(dsg, (DatasetChanges)producer);
        this.spatialIndex = index;
        this.dsgtxn = dsg instanceof Transactional ? (Transactional)dsg : new DatasetGraphWithLock(dsg);
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void begin(ReadWrite readWrite) {
        this.dsgtxn.begin(readWrite);
        if (readWrite == ReadWrite.WRITE) {
            super.getMonitor().start();
            this.needFinish = true;
        }
    }

    public void commit() {
        try {
            if (this.needFinish) {
                super.getMonitor().finish();
            }
            this.needFinish = false;
            this.dsgtxn.commit();
        }
        catch (Throwable ex) {
            log.warn("Exception in commit: " + ex.getMessage(), ex);
            this.dsgtxn.abort();
        }
    }

    public void abort() {
        try {
            if (this.needFinish) {
                this.spatialIndex.abortIndexing();
            }
            this.dsgtxn.abort();
        }
        catch (Throwable ex) {
            log.warn("Exception in abort: " + ex.getMessage(), ex);
        }
    }

    public boolean isInTransaction() {
        return this.dsgtxn.isInTransaction();
    }

    public void end() {
        try {
            this.dsgtxn.end();
        }
        catch (Throwable ex) {
            log.warn("Exception in end: " + ex.getMessage(), ex);
        }
    }
}

