/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.SpatialQueryFuncs;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexLucene
implements SpatialIndex {
    private static Logger log = LoggerFactory.getLogger(SpatialIndexLucene.class);
    private static int MAX_N = 10000;
    public static final Version VER = Version.LUCENE_46;
    public static final FieldType ftIRI = new FieldType();
    private final EntityDefinition docDef;
    private final Directory directory;
    private IndexWriter indexWriter;
    private Analyzer analyzer = new StandardAnalyzer(VER);
    private SpatialStrategy strategy;

    public SpatialIndexLucene(Directory directory, EntityDefinition def) {
        this.directory = directory;
        this.docDef = def;
        int maxLevels = 11;
        GeohashPrefixTree grid = new GeohashPrefixTree(SpatialQuery.ctx, maxLevels);
        this.strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)grid, def.getGeoField());
        this.startIndexing();
        this.finishIndexing();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void startIndexing() {
        try {
            IndexWriterConfig wConfig = new IndexWriterConfig(VER, this.analyzer);
            this.indexWriter = new IndexWriter(this.directory, wConfig);
        }
        catch (IOException e) {
            SpatialIndexLucene.exception(e);
        }
    }

    @Override
    public void finishIndexing() {
        try {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.indexWriter = null;
        }
        catch (IOException e) {
            SpatialIndexLucene.exception(e);
        }
    }

    @Override
    public void abortIndexing() {
        try {
            this.indexWriter.rollback();
        }
        catch (IOException ex) {
            SpatialIndexLucene.exception(ex);
        }
    }

    public void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException ex) {
                SpatialIndexLucene.exception(ex);
            }
        }
    }

    @Override
    public void add(String entityURI, Shape ... shapes) {
        try {
            boolean autoBatch = this.indexWriter == null;
            Document doc = this.doc(entityURI, shapes);
            if (autoBatch) {
                this.startIndexing();
            }
            this.indexWriter.addDocument((Iterable)doc);
            if (autoBatch) {
                this.finishIndexing();
            }
        }
        catch (IOException e) {
            SpatialIndexLucene.exception(e);
        }
    }

    private Document doc(String entityURI, Shape ... shapes) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), entityURI, ftIRI);
        doc.add((IndexableField)entField);
        for (Shape shape : shapes) {
            for (Field f : this.strategy.createIndexableFields(shape)) {
                doc.add((IndexableField)f);
            }
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Node> query(Shape shape, int limit, SpatialOperation operation) {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            List<Node> list = this.query$((IndexReader)indexReader, shape, limit, operation);
            return list;
        }
        catch (Exception ex) {
            SpatialIndexLucene.exception(ex);
            return null;
        }
    }

    private List<Node> query$(IndexReader indexReader, Shape shape, int limit, SpatialOperation operation) throws IOException {
        if (limit <= 0) {
            limit = MAX_N;
        }
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        Point pt = shape.getCenter();
        ValueSource valueSource = this.strategy.makeDistanceValueSource(pt);
        Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(indexSearcher);
        SpatialArgs args = new SpatialArgs(operation, shape);
        args.setDistErr(Double.valueOf(0.0));
        Filter filter = this.strategy.makeFilter(args);
        TopFieldDocs docs = indexSearcher.search((Query)new MatchAllDocsQuery(), filter, limit, distSort);
        ArrayList<Node> results = new ArrayList<Node>();
        for (ScoreDoc sd : docs.scoreDocs) {
            String[] values;
            Document doc = indexSearcher.doc(sd.doc);
            for (String v : values = doc.getValues(this.docDef.getEntityField())) {
                Node n = SpatialQueryFuncs.stringToNode(v);
                results.add(n);
            }
        }
        return results;
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private static void exception(Exception ex) {
        throw new SpatialIndexException(ex);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexed(true);
        ftIRI.freeze();
    }
}

