/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import org.apache.jena.query.spatial.SpatialIndexException;

public class SpatialQueryFuncs {
    public static String subjectToString(Node s) {
        if (s == null) {
            throw new IllegalArgumentException("Subject node can not be null");
        }
        if (!s.isURI() && !s.isBlank()) {
            throw new SpatialIndexException("Found a subject that is not a URI nor a blank node: " + s);
        }
        return SpatialQueryFuncs.nodeToString(s);
    }

    public static String graphNodeToString(Node g) {
        if (g == null) {
            return null;
        }
        if (!g.isURI() && !g.isBlank()) {
            throw new SpatialIndexException("Found a graph label that is not a URI nor a blank node: " + g);
        }
        return SpatialQueryFuncs.nodeToString(g);
    }

    private static String nodeToString(Node n) {
        return n.isURI() ? n.getURI() : "_:" + n.getBlankNodeLabel();
    }

    public static Node stringToNode(String v) {
        if (v.startsWith("_:")) {
            v = v.substring("_:".length());
            return NodeFactory.createAnon((AnonId)new AnonId(v));
        }
        return NodeFactory.createURI((String)v);
    }
}

