/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import org.apache.jena.query.spatial.EntityDefinition;

public class SpatialValueUtil {
    public static boolean isDecimal(Node n) {
        if (NodeUtils.isSimpleString((Node)n) || NodeUtils.isLangString((Node)n)) {
            try {
                Double.parseDouble(n.getLiteralLexicalForm());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        RDFDatatype dtype = n.getLiteralDatatype();
        return dtype.equals(XSDDatatype.XSDfloat) || dtype.equals(XSDDatatype.XSDdecimal) || dtype.equals(XSDDatatype.XSDdouble) || dtype.equals(XSDDatatype.XSDinteger);
    }

    public static boolean isWKTLiteral(LiteralLabel literal) {
        RDFDatatype dtype = literal.getDatatype();
        if (dtype == null) {
            return false;
        }
        return dtype.getURI().equals(EntityDefinition.geosparql_wktLiteral.getURI());
    }
}

