/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterExtendByVar;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionBase;
import com.hp.hpl.jena.sparql.util.IterLib;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.spatial.DatasetGraphSpatial;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.pfunction.SpatialMatch;
import org.apache.jena.query.spatial.pfunction.SpatialOperationWithCircleBase;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialOperationPFBase
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(SpatialOperationPFBase.class);
    protected SpatialIndex server = null;
    private boolean warningIssued = false;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.server = this.chooseTextIndex(dsg);
    }

    protected SpatialIndex chooseTextIndex(DatasetGraph dsg) {
        Object obj = dsg.getContext().get(SpatialQuery.spatialIndex);
        if (obj != null) {
            try {
                return (SpatialIndex)obj;
            }
            catch (ClassCastException ex) {
                Log.warn(SpatialOperationWithCircleBase.class, (String)("Context setting '" + SpatialQuery.spatialIndex + "'is not a SpatialIndex"));
            }
        }
        if (dsg instanceof DatasetGraphSpatial) {
            DatasetGraphSpatial x = (DatasetGraphSpatial)dsg;
            return x.getSpatialIndex();
        }
        Log.warn(SpatialOperationWithCircleBase.class, (String)"Failed to find the spatial index : tried context and as a spatial-enabled dataset");
        return null;
    }

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterator qIter;
        if (this.server == null) {
            if (!this.warningIssued) {
                Log.warn(((Object)((Object)this)).getClass(), (String)"No spatial index - no spatial search performed");
                this.warningIssued = true;
            }
            return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
        }
        DatasetGraph dsg = execCxt.getDataset();
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        if (!argSubject.isNode()) {
            throw new InternalErrorException("Subject is not a node (it was earlier!)");
        }
        Node s = argSubject.getArg();
        if (s.isLiteral()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        SpatialMatch match = this.objectToStruct(argObject);
        if (match == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        QueryIterator queryIterator = qIter = Var.isVar((Node)s) ? this.variableSubject(binding, s, match, execCxt) : this.concreteSubject(binding, s, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, (long)match.getLimit(), execCxt);
        }
        return qIter;
    }

    private QueryIterator variableSubject(Binding binding, Node s, SpatialMatch match, ExecutionContext execCxt) {
        Var v = Var.alloc((Node)s);
        List r = this.query(match);
        r = Iter.iter(r).distinct().toList();
        QueryIterExtendByVar qIter = new QueryIterExtendByVar(binding, v, r.iterator(), execCxt);
        return qIter;
    }

    private QueryIterator concreteSubject(Binding binding, Node s, SpatialMatch match, ExecutionContext execCxt) {
        if (!s.isURI()) {
            log.warn("Subject not a URI: " + s);
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        List<Node> x = this.query(match);
        if (x == null || !x.contains(s)) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
    }

    private List<Node> query(SpatialMatch match) {
        return this.server.query(match.getShape(), match.getLimit(), match.getSpatialOperation());
    }

    protected abstract SpatialMatch objectToStruct(PropFuncArg var1);

    protected abstract SpatialOperation getSpatialOperation();
}

