/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class FtpConfigGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 240L;
    private JTextField server;
    private JTextField port;
    private JTextField remoteFile;
    private JTextField localFile;
    private JTextArea inputData;
    private JCheckBox binaryMode;
    private JCheckBox saveResponseData;
    private boolean displayName = true;
    private JRadioButton getBox;
    private JRadioButton putBox;

    public FtpConfigGui() {
        this(true);
    }

    public FtpConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "ftp_sample_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.server.setText(element.getPropertyAsString("FTPSampler.server"));
        this.port.setText(element.getPropertyAsString("FTPSampler.port"));
        this.remoteFile.setText(element.getPropertyAsString("FTPSampler.filename"));
        this.localFile.setText(element.getPropertyAsString("FTPSampler.localfilename"));
        this.inputData.setText(element.getPropertyAsString("FTPSampler.inputdata"));
        this.binaryMode.setSelected(element.getPropertyAsBoolean("FTPSampler.binarymode", false));
        this.saveResponseData.setSelected(element.getPropertyAsBoolean("FTPSampler.saveresponse", false));
        boolean uploading = element.getPropertyAsBoolean("FTPSampler.upload", false);
        if (uploading) {
            this.putBox.setSelected(true);
        } else {
            this.getBox.setSelected(true);
        }
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty("FTPSampler.server", this.server.getText());
        element.setProperty("FTPSampler.port", this.port.getText());
        element.setProperty("FTPSampler.filename", this.remoteFile.getText());
        element.setProperty("FTPSampler.localfilename", this.localFile.getText());
        element.setProperty("FTPSampler.inputdata", this.inputData.getText());
        element.setProperty("FTPSampler.binarymode", this.binaryMode.isSelected());
        element.setProperty("FTPSampler.saveresponse", this.saveResponseData.isSelected());
        element.setProperty("FTPSampler.upload", this.putBox.isSelected());
    }

    public void clearGui() {
        super.clearGui();
        this.server.setText("");
        this.port.setText("");
        this.remoteFile.setText("");
        this.localFile.setText("");
        this.inputData.setText("");
        this.binaryMode.setSelected(false);
        this.saveResponseData.setSelected(false);
        this.getBox.setSelected(true);
        this.putBox.setSelected(false);
    }

    private JPanel createServerPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"server"));
        this.server = new JTextField(10);
        label.setLabelFor(this.server);
        JPanel serverPanel = new JPanel(new BorderLayout(5, 0));
        serverPanel.add((Component)label, "West");
        serverPanel.add((Component)this.server, "Center");
        return serverPanel;
    }

    private JPanel getPortPanel() {
        this.port = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.port);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.port, "Center");
        return panel;
    }

    private JPanel createLocalFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"ftp_local_file"));
        this.localFile = new JTextField(10);
        label.setLabelFor(this.localFile);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.localFile, "Center");
        return filenamePanel;
    }

    private JPanel createLocalFileContentsPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"ftp_local_file_contents"));
        this.inputData = new JTextArea();
        label.setLabelFor(this.inputData);
        JPanel contentsPanel = new JPanel(new BorderLayout(5, 0));
        contentsPanel.add((Component)label, "West");
        contentsPanel.add((Component)this.inputData, "Center");
        return contentsPanel;
    }

    private JPanel createRemoteFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"ftp_remote_file"));
        this.remoteFile = new JTextField(10);
        label.setLabelFor(this.remoteFile);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.remoteFile, "Center");
        return filenamePanel;
    }

    private JPanel createOptionsPanel() {
        ButtonGroup group = new ButtonGroup();
        this.getBox = new JRadioButton(JMeterUtils.getResString((String)"ftp_get"));
        group.add(this.getBox);
        this.getBox.setSelected(true);
        this.putBox = new JRadioButton(JMeterUtils.getResString((String)"ftp_put"));
        group.add(this.putBox);
        this.binaryMode = new JCheckBox(JMeterUtils.getResString((String)"ftp_binary_mode"));
        this.saveResponseData = new JCheckBox(JMeterUtils.getResString((String)"ftp_save_response_data"));
        HorizontalPanel optionsPanel = new HorizontalPanel();
        optionsPanel.add(this.getBox);
        optionsPanel.add(this.putBox);
        optionsPanel.add(this.binaryMode);
        optionsPanel.add(this.saveResponseData);
        return optionsPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        HorizontalPanel serverPanel = new HorizontalPanel();
        serverPanel.add((Component)this.createServerPanel(), "Center");
        serverPanel.add((Component)this.getPortPanel(), "East");
        mainPanel.add((Component)serverPanel);
        mainPanel.add((Component)this.createRemoteFilenamePanel());
        mainPanel.add((Component)this.createLocalFilenamePanel());
        mainPanel.add((Component)this.createLocalFileContentsPanel());
        mainPanel.add((Component)this.createOptionsPanel());
        this.add((Component)mainPanel, "Center");
    }
}

