/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.DateUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CacheManager
extends ConfigTestElement
implements TestStateListener,
TestIterationListener,
Serializable {
    private static final Date EXPIRED_DATE = new Date(0L);
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String[] CACHEABLE_METHODS = JMeterUtils.getPropDefault((String)"cacheable_methods", (String)"GET").split("[ ,]");
    public static final String CLEAR = "clearEachIteration";
    public static final String USE_EXPIRES = "useExpires";
    public static final String MAX_SIZE = "maxSize";
    private transient InheritableThreadLocal<Map<String, CacheEntry>> threadCache;
    private transient boolean useExpires;
    private static final int DEFAULT_MAX_SIZE = 5000;
    private static final long ONE_YEAR_MS = 31536000000L;
    private transient Map<String, CacheEntry> localCache;

    public CacheManager() {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR, false));
        this.setProperty((JMeterProperty)new BooleanProperty(USE_EXPIRES, false));
        this.clearCache();
        this.useExpires = false;
    }

    CacheManager(Map<String, CacheEntry> localCache, boolean useExpires) {
        this.localCache = localCache;
        this.useExpires = useExpires;
    }

    public void saveDetails(URLConnection conn, HTTPSampleResult res) {
        if (this.isCacheable(res) && !this.hasVaryHeader(conn)) {
            String lastModified = conn.getHeaderField("Last-Modified");
            String expires = conn.getHeaderField("Expires");
            String etag = conn.getHeaderField("Etag");
            String url = conn.getURL().toString();
            String cacheControl = conn.getHeaderField("Cache-Control");
            String date = conn.getHeaderField("Date");
            this.setCache(lastModified, cacheControl, expires, etag, url, date);
        }
    }

    private boolean hasVaryHeader(URLConnection conn) {
        return conn.getHeaderField("Vary") != null;
    }

    @Deprecated
    public void saveDetails(HttpMethod method, HTTPSampleResult res) throws URIException {
        if (this.isCacheable(res) && !this.hasVaryHeader(method)) {
            String lastModified = this.getHeader(method, "Last-Modified");
            String expires = this.getHeader(method, "Expires");
            String etag = this.getHeader(method, "Etag");
            String url = method.getURI().toString();
            String cacheControl = this.getHeader(method, "Cache-Control");
            String date = this.getHeader(method, "Date");
            this.setCache(lastModified, cacheControl, expires, etag, url, date);
        }
    }

    @Deprecated
    private boolean hasVaryHeader(HttpMethod method) {
        return this.getHeader(method, "Vary") != null;
    }

    public void saveDetails(HttpResponse method, HTTPSampleResult res) {
        if (this.isCacheable(res) && !this.hasVaryHeader(method)) {
            String lastModified = this.getHeader(method, "Last-Modified");
            String expires = this.getHeader(method, "Expires");
            String etag = this.getHeader(method, "Etag");
            String cacheControl = this.getHeader(method, "Cache-Control");
            String date = this.getHeader(method, "Date");
            this.setCache(lastModified, cacheControl, expires, etag, res.getUrlAsString(), date);
        }
    }

    private boolean hasVaryHeader(HttpResponse method) {
        return this.getHeader(method, "Vary") != null;
    }

    private void setCache(String lastModified, String cacheControl, String expires, String etag, String url, String date) {
        if (log.isDebugEnabled()) {
            log.debug("setCache(" + lastModified + "," + cacheControl + "," + expires + "," + etag + "," + url + "," + date + ")");
        }
        Date expiresDate = null;
        if (this.useExpires) {
            String MAX_AGE = "max-age=";
            if (cacheControl != null && cacheControl.contains("no-store")) {
                return;
            }
            if (expires != null) {
                try {
                    expiresDate = DateUtils.parseDate((String)expires);
                }
                catch (IllegalArgumentException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to parse Expires: '" + expires + "' " + e);
                    }
                    expiresDate = EXPIRED_DATE;
                }
            }
            if (cacheControl != null && !cacheControl.contains("no-cache")) {
                if (cacheControl.contains("max-age=")) {
                    long maxAgeInSecs = Long.parseLong(cacheControl.substring(cacheControl.indexOf("max-age=") + "max-age=".length()).split("[, ]")[0]);
                    expiresDate = new Date(System.currentTimeMillis() + maxAgeInSecs * 1000L);
                } else if (expires == null) {
                    if (!StringUtils.isEmpty((CharSequence)lastModified) && !StringUtils.isEmpty((CharSequence)date)) {
                        try {
                            Date responseDate = DateUtils.parseDate((String)date);
                            Date lastModifiedAsDate = DateUtils.parseDate((String)lastModified);
                            expiresDate = new Date(System.currentTimeMillis() + Math.round((double)(responseDate.getTime() - lastModifiedAsDate.getTime()) * 0.1));
                        }
                        catch (IllegalArgumentException e) {
                            if (log.isWarnEnabled()) {
                                log.warn("Failed computing expiration date with following info:" + lastModified + "," + cacheControl + "," + expires + "," + etag + "," + url + "," + date);
                            }
                            expiresDate = new Date(System.currentTimeMillis() + 31536000000L);
                        }
                    } else {
                        expiresDate = new Date(System.currentTimeMillis() + 31536000000L);
                    }
                }
            }
        }
        this.getCache().put(url, new CacheEntry(lastModified, expiresDate, etag));
    }

    @Deprecated
    private String getHeader(HttpMethod method, String name) {
        Header hdr = method.getResponseHeader(name);
        return hdr != null ? hdr.getValue() : null;
    }

    private String getHeader(HttpResponse method, String name) {
        org.apache.http.Header hdr = method.getLastHeader(name);
        return hdr != null ? hdr.getValue() : null;
    }

    private boolean isCacheable(HTTPSampleResult res) {
        String responseCode = res.getResponseCode();
        return this.isCacheableMethod(res) && "200".compareTo(responseCode) <= 0 && "299".compareTo(responseCode) >= 0;
    }

    private boolean isCacheableMethod(HTTPSampleResult res) {
        String resMethod = res.getHTTPMethod();
        for (String method : CACHEABLE_METHODS) {
            if (!method.equalsIgnoreCase(resMethod)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setHeaders(URL url, HttpMethod method) {
        CacheEntry entry = this.getCache().get(url.toString());
        if (log.isDebugEnabled()) {
            log.debug(method.getName() + "(OACH) " + url.toString() + " " + entry);
        }
        if (entry != null) {
            String etag;
            String lastModified = entry.getLastModified();
            if (lastModified != null) {
                method.setRequestHeader("If-Modified-Since", lastModified);
            }
            if ((etag = entry.getEtag()) != null) {
                method.setRequestHeader("If-None-Match", etag);
            }
        }
    }

    public void setHeaders(URL url, HttpRequestBase request) {
        CacheEntry entry = this.getCache().get(url.toString());
        if (log.isDebugEnabled()) {
            log.debug(request.getMethod() + "(OAH) " + url.toString() + " " + entry);
        }
        if (entry != null) {
            String etag;
            String lastModified = entry.getLastModified();
            if (lastModified != null) {
                request.setHeader("If-Modified-Since", lastModified);
            }
            if ((etag = entry.getEtag()) != null) {
                request.setHeader("If-None-Match", etag);
            }
        }
    }

    public void setHeaders(HttpURLConnection conn, URL url) {
        CacheEntry entry = this.getCache().get(url.toString());
        if (log.isDebugEnabled()) {
            log.debug(conn.getRequestMethod() + "(Java) " + url.toString() + " " + entry);
        }
        if (entry != null) {
            String etag;
            String lastModified = entry.getLastModified();
            if (lastModified != null) {
                conn.addRequestProperty("If-Modified-Since", lastModified);
            }
            if ((etag = entry.getEtag()) != null) {
                conn.addRequestProperty("If-None-Match", etag);
            }
        }
    }

    public boolean inCache(URL url) {
        Date expiresDate;
        CacheEntry entry = this.getCache().get(url.toString());
        if (log.isDebugEnabled()) {
            log.debug("inCache " + url.toString() + " " + entry);
        }
        if (entry != null && (expiresDate = entry.getExpires()) != null) {
            if (expiresDate.after(new Date())) {
                if (log.isDebugEnabled()) {
                    log.debug("Expires= " + expiresDate + " (Valid)");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Expires= " + expiresDate + " (Expired)");
            }
        }
        return false;
    }

    private Map<String, CacheEntry> getCache() {
        return this.localCache != null ? this.localCache : (Map)this.threadCache.get();
    }

    public boolean getClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR, clear));
    }

    public boolean getUseExpires() {
        return this.getPropertyAsBoolean(USE_EXPIRES);
    }

    public void setUseExpires(boolean expires) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_EXPIRES, expires));
    }

    public int getMaxSize() {
        return this.getPropertyAsInt(MAX_SIZE, 5000);
    }

    public void setMaxSize(int size) {
        this.setProperty(MAX_SIZE, size, 5000);
    }

    public void clear() {
        super.clear();
        this.clearCache();
    }

    private void clearCache() {
        log.debug("Clear cache");
        this.threadCache = new InheritableThreadLocal<Map<String, CacheEntry>>(){

            @Override
            protected Map<String, CacheEntry> initialValue() {
                LRUMap map = new LRUMap(CacheManager.this.getMaxSize());
                return Collections.synchronizedMap(map);
            }
        };
    }

    public CacheManager createCacheManagerProxy() {
        return new CacheManager(this.getCache(), this.useExpires);
    }

    public void testStarted() {
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.getClearEachIteration()) {
            this.clearCache();
        }
        this.useExpires = this.getUseExpires();
    }

    static {
        log.info("Will only cache the following methods: " + Arrays.toString(CACHEABLE_METHODS));
    }

    static class CacheEntry {
        private final String lastModified;
        private final String etag;
        private final Date expires;

        public CacheEntry(String lastModified, Date expires, String etag) {
            this.lastModified = lastModified;
            this.etag = etag;
            this.expires = expires;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getEtag() {
            return this.etag;
        }

        public String toString() {
            return this.lastModified + " " + this.etag;
        }

        public Date getExpires() {
            return this.expires;
        }
    }
}

