/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public class DNSCacheManager
extends ConfigTestElement
implements TestIterationListener,
Serializable,
DnsResolver {
    private static final long serialVersionUID = 2120L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private transient SystemDefaultDnsResolver systemDefaultDnsResolver = null;
    private Map<String, InetAddress[]> cache = null;
    private transient Resolver resolver = null;
    public static final String CLEAR_CACHE_EACH_ITER = "DNSCacheManager.clearEachIteration";
    public static final String SERVERS = "DNSCacheManager.servers";
    public static final String IS_CUSTOM_RESOLVER = "DNSCacheManager.isCustomResolver";
    public static final boolean DEFAULT_CLEAR_CACHE_EACH_ITER = false;
    public static final String DEFAULT_SERVERS = "";
    public static final boolean DEFAULT_IS_CUSTOM_RESOLVER = false;
    private final transient Cache lookupCache;
    private transient int timeoutMs;

    public DNSCacheManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(SERVERS, new ArrayList()));
        this.lookupCache = new Cache();
        this.lookupCache.setMaxCache(0);
        this.lookupCache.setMaxEntries(0);
    }

    public Object clone() {
        DNSCacheManager clone = (DNSCacheManager)super.clone();
        clone.systemDefaultDnsResolver = new SystemDefaultDnsResolver();
        clone.cache = new LinkedHashMap<String, InetAddress[]>();
        CollectionProperty dnsServers = this.getServers();
        try {
            String[] serverNames = new String[dnsServers.size()];
            int index = 0;
            for (JMeterProperty jMeterProperty : dnsServers) {
                serverNames[index] = jMeterProperty.getStringValue();
                ++index;
            }
            clone.resolver = new ExtendedResolver(serverNames);
            log.debug("Using DNS Resolvers: " + Arrays.asList(((ExtendedResolver)clone.resolver).getResolvers()));
            ((ExtendedResolver)clone.resolver).setLoadBalance(true);
        }
        catch (UnknownHostException uhe) {
            log.warn("Failed to create Extended resolver: " + uhe.getMessage());
        }
        return clone;
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (this.cache.containsKey(host)) {
            if (log.isDebugEnabled()) {
                log.debug("Cache hit thr#" + JMeterContextService.getContext().getThreadNum() + ": " + host + "=>" + Arrays.toString(this.cache.get(host)));
            }
            return this.cache.get(host);
        }
        Object[] addresses = this.requestLookup(host);
        if (log.isDebugEnabled()) {
            log.debug("Cache miss thr#" + JMeterContextService.getContext().getThreadNum() + ": " + host + "=>" + Arrays.toString(addresses));
        }
        this.cache.put(host, (InetAddress[])addresses);
        return addresses;
    }

    private InetAddress[] requestLookup(String host) throws UnknownHostException {
        Object[] addresses = null;
        if (this.isCustomResolver() && ((ExtendedResolver)this.resolver).getResolvers().length > 0) {
            try {
                Lookup lookup = new Lookup(host, 1);
                lookup.setCache(this.lookupCache);
                if (this.timeoutMs > 0) {
                    this.resolver.setTimeout(this.timeoutMs / 1000, this.timeoutMs % 1000);
                }
                lookup.setResolver(this.resolver);
                Record[] records = lookup.run();
                if (records == null || records.length == 0) {
                    throw new UnknownHostException("Failed to resolve host name: " + host);
                }
                addresses = new InetAddress[records.length];
                for (int i = 0; i < records.length; ++i) {
                    addresses[i] = ((ARecord)records[i]).getAddress();
                }
            }
            catch (TextParseException tpe) {
                log.debug("Failed to create Lookup object: " + (Object)((Object)tpe));
            }
        } else {
            addresses = this.systemDefaultDnsResolver.resolve(host);
            if (log.isDebugEnabled()) {
                log.debug("Cache miss: " + host + " Thread #" + JMeterContextService.getContext().getThreadNum() + ", resolved with system resolver into " + Arrays.toString(addresses));
            }
        }
        return addresses;
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.isClearEachIteration()) {
            this.cache.clear();
        }
    }

    public void clear() {
        super.clear();
        this.clearServers();
    }

    private void clearServers() {
        log.debug("Clear all servers from store");
        this.setProperty((JMeterProperty)new CollectionProperty(SERVERS, new ArrayList()));
    }

    public void addServer(String dnsServer) {
        this.getServers().addItem((Object)dnsServer);
    }

    public CollectionProperty getServers() {
        return (CollectionProperty)this.getProperty(SERVERS);
    }

    public boolean isClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR_CACHE_EACH_ITER, false);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR_CACHE_EACH_ITER, clear));
    }

    public boolean isCustomResolver() {
        return this.getPropertyAsBoolean(IS_CUSTOM_RESOLVER, false);
    }

    public void setCustomResolver(boolean isCustomResolver) {
        this.setProperty(IS_CUSTOM_RESOLVER, isCustomResolver);
    }

    void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    int getTimeoutMs() {
        return this.timeoutMs;
    }
}

