/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class JsoupBasedHtmlParser
extends HTMLParser {
    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, URLCollection coll, String encoding) throws HTMLParseException {
        try {
            String contents = new String(html, encoding);
            Document doc = Jsoup.parse((String)contents);
            JMeterNodeVisitor nodeVisitor = new JMeterNodeVisitor(new URLPointer(baseUrl), coll);
            new NodeTraversor((NodeVisitor)nodeVisitor).traverse((Node)doc);
            return coll.iterator();
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
    }

    private static final class JMeterNodeVisitor
    implements NodeVisitor {
        private URLCollection urls;
        private URLPointer baseUrl;

        public JMeterNodeVisitor(URLPointer baseUrl, URLCollection urls) {
            this.urls = urls;
            this.baseUrl = baseUrl;
        }

        private void extractAttribute(Element tag, String attributeName) {
            String url = tag.attr(attributeName);
            if (!StringUtils.isEmpty((CharSequence)url)) {
                this.urls.addURL(url, this.baseUrl.url);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void head(Node node, int depth) {
            if (!(node instanceof Element)) {
                return;
            }
            tag = (Element)node;
            tagName = tag.tagName().toLowerCase();
            if (tagName.equals("body")) {
                this.extractAttribute(tag, "background");
            } else if (tagName.equals("script")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("base")) {
                baseref = tag.attr("href");
                try {
                    if (StringUtils.isEmpty((CharSequence)baseref)) ** GOTO lbl51
                    URLPointer.access$002(this.baseUrl, ConversionUtils.makeRelativeURL(URLPointer.access$000(this.baseUrl), baseref));
                }
                catch (MalformedURLException e1) {
                    throw new RuntimeException(e1);
                }
            } else if (tagName.equals("img")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("applet")) {
                this.extractAttribute(tag, "code");
            } else if (tagName.equals("object")) {
                this.extractAttribute(tag, "codebase");
                this.extractAttribute(tag, "data");
            } else if (tagName.equals("input")) {
                if ("image".equalsIgnoreCase(tag.attr("type"))) {
                    this.extractAttribute(tag, "src");
                }
            } else if (tagName.equals("script")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("frame") || tagName.equals("iframe")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("embed")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("bgsound")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("link")) {
                if ("stylesheet".equalsIgnoreCase(tag.attr("rel"))) {
                    this.extractAttribute(tag, "href");
                }
            } else {
                this.extractAttribute(tag, "background");
            }
lbl51:
            // 14 sources

            styleTagStr = tag.attr("style");
            if (styleTagStr != null) {
                HtmlParsingUtils.extractStyleURLs(URLPointer.access$000(this.baseUrl), this.urls, styleTagStr);
            }
        }

        public void tail(Node arg0, int arg1) {
        }
    }

    private static class URLPointer {
        private URL url;

        private URLPointer(URL newUrl) {
            this.url = newUrl;
        }

        static /* synthetic */ URL access$002(URLPointer x0, URL x1) {
            x0.url = x1;
            return x0.url;
        }
    }
}

