/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.math;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableLong;

public abstract class StatCalculator<T extends Number> {
    private final Map<T, MutableLong> valuesMap = new TreeMap<T, MutableLong>();
    private double sum = 0.0;
    private double sumOfSquares = 0.0;
    private double mean = 0.0;
    private double deviation = 0.0;
    private long count = 0L;
    private T min;
    private T max;
    private long bytes = 0L;
    private final T ZERO;
    private final T MAX_VALUE;
    private final T MIN_VALUE;

    public StatCalculator(T zero, T min, T max) {
        this.ZERO = zero;
        this.MAX_VALUE = max;
        this.MIN_VALUE = min;
        this.min = this.MAX_VALUE;
        this.max = this.MIN_VALUE;
    }

    public void clear() {
        this.valuesMap.clear();
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.mean = 0.0;
        this.deviation = 0.0;
        this.count = 0L;
        this.bytes = 0L;
        this.max = this.MIN_VALUE;
        this.min = this.MAX_VALUE;
    }

    public void addBytes(long newValue) {
        this.bytes += newValue;
    }

    public void addAll(StatCalculator<T> calc) {
        for (Map.Entry<T, MutableLong> ent : calc.valuesMap.entrySet()) {
            this.addEachValue((Number)ent.getKey(), ent.getValue().longValue());
        }
    }

    public T getMedian() {
        return this.getPercentPoint(0.5);
    }

    public long getTotalBytes() {
        return this.bytes;
    }

    public T getPercentPoint(float percent) {
        return this.getPercentPoint((double)percent);
    }

    public T getPercentPoint(double percent) {
        if (this.count <= 0L) {
            return this.ZERO;
        }
        if (percent >= 1.0) {
            return this.getMax();
        }
        long target = Math.round((double)this.count * percent);
        try {
            for (Map.Entry<T, MutableLong> val : this.valuesMap.entrySet()) {
                if ((target -= val.getValue().longValue()) > 0L) continue;
                return (T)((Number)val.getKey());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return this.ZERO;
    }

    public Map<Number, Number[]> getDistribution() {
        HashMap<Number, Number[]> items = new HashMap<Number, Number[]>();
        for (Map.Entry<T, MutableLong> entry : this.valuesMap.entrySet()) {
            Number[] dis = new Number[]{(Number)entry.getKey(), (Number)entry.getValue()};
            items.put((Number)entry.getKey(), dis);
        }
        return items;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.deviation;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    protected abstract T divide(T var1, int var2);

    protected abstract T divide(T var1, long var2);

    void addEachValue(T val, long sampleCount) {
        this.count += sampleCount;
        double currentVal = ((Number)val).doubleValue();
        this.sum += currentVal * (double)sampleCount;
        this.sumOfSquares += currentVal * currentVal * (double)sampleCount;
        this.updateValueCount(val, sampleCount);
        this.calculateDerivedValues(val);
    }

    public void addValue(T val, long sampleCount) {
        this.count += sampleCount;
        double currentVal = ((Number)val).doubleValue();
        this.sum += currentVal;
        T actualValue = val;
        if (sampleCount > 1L) {
            this.sumOfSquares += currentVal * currentVal / (double)sampleCount;
            actualValue = this.divide(val, sampleCount);
        } else {
            this.sumOfSquares += currentVal * currentVal;
        }
        this.updateValueCount(actualValue, sampleCount);
        this.calculateDerivedValues(actualValue);
    }

    private void calculateDerivedValues(T actualValue) {
        this.mean = this.sum / (double)this.count;
        this.deviation = Math.sqrt(this.sumOfSquares / (double)this.count - this.mean * this.mean);
        if (((Comparable)actualValue).compareTo(this.max) > 0) {
            this.max = actualValue;
        }
        if (((Comparable)actualValue).compareTo(this.min) < 0) {
            this.min = actualValue;
        }
    }

    public void addValue(T val) {
        this.addValue(val, 1L);
    }

    private void updateValueCount(T actualValue, long sampleCount) {
        MutableLong count = this.valuesMap.get(actualValue);
        if (count != null) {
            count.add(sampleCount);
        } else {
            this.valuesMap.put(actualValue, new MutableLong(sampleCount));
        }
    }
}

