/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs.jsonb.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.json.JsonStructure;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Priority(value=4900)
public class JsonbJaxrsProvider<T>
implements MessageBodyWriter<T>,
MessageBodyReader<T>,
AutoCloseable {
    protected final Collection<String> ignores;
    protected final JsonbConfig config = new JsonbConfig();
    protected volatile Function<Class<?>, Jsonb> delegate = null;
    private boolean customized;
    @Context
    private Providers providers;

    public JsonbJaxrsProvider() {
        this(null);
    }

    protected JsonbJaxrsProvider(Collection<String> ignores) {
        this.ignores = ignores;
    }

    private boolean isIgnored(Class<?> type) {
        return this.ignores != null && this.ignores.contains(type.getName());
    }

    public void setFailOnUnknownProperties(boolean active) {
        this.config.setProperty("johnzon.fail-on-unknown-properties", (Object)active);
        this.customized = true;
    }

    public void setOtherProperties(final String others) {
        Properties properties = new Properties(){
            {
                try {
                    this.load(new StringReader(others));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        properties.stringPropertyNames().forEach(k -> this.config.setProperty(k, (Object)properties.getProperty((String)k)));
        this.customized = true;
    }

    public void setIJson(boolean active) {
        this.config.withStrictIJSON(Boolean.valueOf(active));
        this.customized = true;
    }

    public void setEncoding(String encoding) {
        this.config.withEncoding(encoding);
        this.customized = true;
    }

    public void setBinaryDataStrategy(String binaryDataStrategy) {
        this.config.withBinaryDataStrategy(binaryDataStrategy);
        this.customized = true;
    }

    public void setPropertyNamingStrategy(String propertyNamingStrategy) {
        this.config.withPropertyNamingStrategy(propertyNamingStrategy);
        this.customized = true;
    }

    public void setPropertyOrderStrategy(String propertyOrderStrategy) {
        this.config.withPropertyOrderStrategy(propertyOrderStrategy);
        this.customized = true;
    }

    public void setNullValues(boolean nulls) {
        this.config.withNullValues(Boolean.valueOf(nulls));
        this.customized = true;
    }

    public void setPretty(boolean pretty) {
        this.config.withFormatting(Boolean.valueOf(pretty));
        this.customized = true;
    }

    public void setInterfaceImplementationMapping(Map<String, String> interfaceImplementationMapping) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Function<String, Class> load = name -> {
            try {
                return loader.loadClass(name.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        };
        this.config.setProperty("johnzon.interfaceImplementationMapping", interfaceImplementationMapping.entrySet().stream().collect(Collectors.toMap(it -> (Class)load.apply((String)it.getKey()), it -> (Class)load.apply((String)it.getValue()))));
        this.customized = true;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(type) && !InputStream.class.isAssignableFrom(type) && !Reader.class.isAssignableFrom(type) && !Response.class.isAssignableFrom(type) && !CharSequence.class.isAssignableFrom(type) && !JsonStructure.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(type) && !InputStream.class.isAssignableFrom(type) && !OutputStream.class.isAssignableFrom(type) && !Writer.class.isAssignableFrom(type) && !StreamingOutput.class.isAssignableFrom(type) && !CharSequence.class.isAssignableFrom(type) && !Response.class.isAssignableFrom(type) && !JsonStructure.class.isAssignableFrom(type);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return (T)this.getJsonb(type).fromJson(entityStream, genericType);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.getJsonb(type).toJson(t, entityStream);
    }

    protected Jsonb createJsonb() {
        return JsonbBuilder.create((JsonbConfig)this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Jsonb getJsonb(Class<?> type) {
        if (this.delegate == null) {
            JsonbJaxrsProvider jsonbJaxrsProvider = this;
            synchronized (jsonbJaxrsProvider) {
                if (this.delegate == null) {
                    ContextResolver contextResolver = this.providers.getContextResolver(Jsonb.class, MediaType.APPLICATION_JSON_TYPE);
                    if (contextResolver != null) {
                        if (this.customized) {
                            Logger.getLogger(JsonbJaxrsProvider.class.getName()).warning("Customizations done on the Jsonb instance will be ignored because a ContextResolver<Jsonb> was found");
                        }
                        this.delegate = new DynamicInstance(contextResolver);
                    } else {
                        this.delegate = new ProvidedInstance(this.createJsonb());
                    }
                }
            }
        }
        return this.delegate.apply(type);
    }

    @Override
    public synchronized void close() throws Exception {
        if (AutoCloseable.class.isInstance(this.delegate)) {
            ((AutoCloseable)AutoCloseable.class.cast(this.delegate)).close();
        }
    }

    private static final class ProvidedInstance
    implements Function<Class<?>, Jsonb>,
    AutoCloseable {
        private final Jsonb instance;

        private ProvidedInstance(Jsonb instance) {
            this.instance = instance;
        }

        @Override
        public Jsonb apply(Class<?> aClass) {
            return this.instance;
        }

        @Override
        public void close() throws Exception {
            this.instance.close();
        }
    }

    private static final class DynamicInstance
    implements Function<Class<?>, Jsonb> {
        private final ContextResolver<Jsonb> contextResolver;

        private DynamicInstance(ContextResolver<Jsonb> resolver) {
            this.contextResolver = resolver;
        }

        @Override
        public Jsonb apply(Class<?> type) {
            return (Jsonb)this.contextResolver.getContext(type);
        }
    }
}

