/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.math.BigDecimal;
import java.util.function.Supplier;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;

class JsonValueParserAdapter<T extends JsonValue>
implements JsonParser {
    private final T jsonValue;

    public static JsonParser createFor(JsonValue jsonValue, Supplier<JsonParserFactory> parserFactoryProvider) {
        switch (jsonValue.getValueType()) {
            case OBJECT: {
                return parserFactoryProvider.get().createParser(jsonValue.asJsonObject());
            }
            case ARRAY: {
                return parserFactoryProvider.get().createParser(jsonValue.asJsonArray());
            }
            case STRING: {
                return new JsonStringParserAdapter((JsonString)jsonValue);
            }
            case NUMBER: {
                return new JsonNumberParserAdapter((JsonNumber)jsonValue);
            }
        }
        return new JsonValueParserAdapter<JsonValue>(jsonValue);
    }

    JsonValueParserAdapter(T jsonValue) {
        this.jsonValue = jsonValue;
    }

    public boolean hasNext() {
        return false;
    }

    public JsonParser.Event next() {
        throw new UnsupportedOperationException("next() no supported for " + this.jsonValue.getValueType());
    }

    public String getString() {
        throw new UnsupportedOperationException("next() no supported for " + this.jsonValue.getValueType());
    }

    public boolean isIntegralNumber() {
        throw new UnsupportedOperationException("isIntegralNumber() not supported for " + this.jsonValue.getValueType());
    }

    public int getInt() {
        throw new UnsupportedOperationException("getInt() not supported for " + this.jsonValue.getValueType());
    }

    public long getLong() {
        throw new UnsupportedOperationException("getLong() not supported for " + this.jsonValue.getValueType());
    }

    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException("getBigDecimal() not supported for " + this.jsonValue.getValueType());
    }

    public JsonLocation getLocation() {
        throw new UnsupportedOperationException("getLocation() not supported for " + this.jsonValue.getValueType());
    }

    public void close() {
    }

    public T getValue() {
        return this.jsonValue;
    }

    private static class JsonNumberParserAdapter
    extends JsonValueParserAdapter<JsonNumber> {
        public JsonNumberParserAdapter(JsonNumber jsonValue) {
            super(jsonValue);
        }

        @Override
        public boolean isIntegralNumber() {
            return ((JsonNumber)this.getValue()).isIntegral();
        }

        @Override
        public int getInt() {
            return ((JsonNumber)this.getValue()).intValueExact();
        }

        @Override
        public long getLong() {
            return ((JsonNumber)this.getValue()).longValueExact();
        }

        @Override
        public BigDecimal getBigDecimal() {
            return ((JsonNumber)this.getValue()).bigDecimalValue();
        }
    }

    private static class JsonStringParserAdapter
    extends JsonValueParserAdapter<JsonString> {
        public JsonStringParserAdapter(JsonString jsonValue) {
            super(jsonValue);
        }

        @Override
        public String getString() {
            return ((JsonString)this.getValue()).getString();
        }
    }
}

