/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.regex;

import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.Regex;
import org.joni.Syntax;

public class JoniRegex
implements Predicate<CharSequence> {
    private final Regex regex;
    private final String toStr;

    public JoniRegex(String regex) {
        if (regex.startsWith("/") && regex.length() > 1) {
            int end = regex.lastIndexOf(47);
            if (end < 0) {
                this.regex = new Regex(regex);
            } else {
                String optStr = regex.substring(end + 1);
                int option = 8;
                if (optStr.contains("i")) {
                    option |= 1;
                } else if (optStr.contains("m")) {
                    option &= 0xFFFFFFF7;
                    option |= 0x40;
                }
                this.regex = new Regex(regex.getBytes(StandardCharsets.US_ASCII), 1, end, option, (Encoding)ASCIIEncoding.INSTANCE, Syntax.ECMAScript);
            }
        } else {
            this.regex = new Regex(regex);
        }
        this.toStr = "JoniRegex{" + regex + '}';
    }

    @Override
    public boolean test(CharSequence string) {
        return this.regex.matcher(string.toString().getBytes(StandardCharsets.UTF_8)).search(0, string.length(), 0) > -1;
    }

    public String toString() {
        return this.toStr;
    }
}

