/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class PatternValidation
implements ValidationExtension {
    private final Function<String, Predicate<CharSequence>> predicateFactory;

    public PatternValidation(Function<String, Predicate<CharSequence>> predicateFactory) {
        this.predicateFactory = predicateFactory;
    }

    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        if (model.getSchema().getString("type", "object").equals("string")) {
            return Optional.ofNullable((JsonValue)model.getSchema().get((Object)"pattern")).filter(val -> val.getValueType() == JsonValue.ValueType.STRING).map(pattern -> new Impl(model.toPointer(), model.getValueProvider(), this.predicateFactory.apply(((JsonString)JsonString.class.cast(pattern)).getString())));
        }
        return Optional.empty();
    }

    private static class Impl
    extends BaseValidation {
        private final Predicate<CharSequence> matcher;

        private Impl(String pointer, Function<JsonValue, JsonValue> valueProvider, Predicate<CharSequence> matcher) {
            super(pointer, valueProvider, JsonValue.ValueType.STRING);
            this.matcher = matcher;
        }

        @Override
        public Stream<ValidationResult.ValidationError> onString(JsonString value) {
            if (!this.matcher.test(value.getString())) {
                return Stream.of(new ValidationResult.ValidationError(this.pointer, value + " doesn't match " + this.matcher));
            }
            return Stream.empty();
        }

        public String toString() {
            return "Pattern{regex=" + this.matcher + ", pointer='" + this.pointer + "'}";
        }
    }
}

