/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import jakarta.json.JsonArray;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class TypeValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        JsonValue value = (JsonValue)model.getSchema().get((Object)"type");
        if (JsonString.class.isInstance(value)) {
            return Optional.of(new Impl(model.toPointer(), model.getValueProvider(), (JsonValue.ValueType[])this.mapType((JsonValue)JsonString.class.cast(value)).toArray(JsonValue.ValueType[]::new)));
        }
        if (JsonArray.class.isInstance(value)) {
            return Optional.of(new Impl(model.toPointer(), model.getValueProvider(), (JsonValue.ValueType[])value.asJsonArray().stream().flatMap(this::mapType).toArray(JsonValue.ValueType[]::new)));
        }
        throw new IllegalArgumentException(value + " is neither an array or string nor a string");
    }

    private Stream<? extends JsonValue.ValueType> mapType(JsonValue value) {
        switch (((JsonString)JsonString.class.cast(value)).getString()) {
            case "null": {
                return Stream.of(JsonValue.ValueType.NULL);
            }
            case "string": {
                return Stream.of(JsonValue.ValueType.STRING);
            }
            case "number": 
            case "integer": {
                return Stream.of(JsonValue.ValueType.NUMBER);
            }
            case "array": {
                return Stream.of(JsonValue.ValueType.ARRAY);
            }
            case "boolean": {
                return Stream.of(JsonValue.ValueType.FALSE, JsonValue.ValueType.TRUE);
            }
        }
        return Stream.of(JsonValue.ValueType.OBJECT);
    }

    private static class Impl
    extends BaseValidation {
        private final Collection<JsonValue.ValueType> types;

        private Impl(String pointer, Function<JsonValue, JsonValue> extractor, JsonValue.ValueType ... types) {
            super(pointer, extractor, types[0]);
            this.types = Stream.concat(Stream.of(types), Stream.of(JsonValue.ValueType.NULL)).distinct().sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
        }

        @Override
        public Stream<ValidationResult.ValidationError> apply(JsonValue root) {
            if (this.isNull(root)) {
                return Stream.empty();
            }
            JsonValue value = (JsonValue)this.extractor.apply(root);
            if (value == null || this.types.contains(value.getValueType())) {
                return Stream.empty();
            }
            return Stream.of(new ValidationResult.ValidationError(this.pointer, "Expected " + this.types + " but got " + value.getValueType()));
        }

        public String toString() {
            return "Type{type=" + this.types + ", pointer='" + this.pointer + "'}";
        }
    }
}

