/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseNumberValidation;

public class ExclusiveMaximumValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        if (model.getSchema().getString("type", "object").equals("number")) {
            return Optional.ofNullable((JsonValue)model.getSchema().get((Object)"exclusiveMaximum")).filter(v -> v.getValueType() == JsonValue.ValueType.NUMBER).map(m -> new Impl(model.toPointer(), model.getValueProvider(), ((JsonNumber)JsonNumber.class.cast(m)).doubleValue()));
        }
        return Optional.empty();
    }

    private static class Impl
    extends BaseNumberValidation {
        private Impl(String pointer, Function<JsonValue, JsonValue> valueProvider, double bound) {
            super(pointer, valueProvider, bound);
        }

        @Override
        protected boolean isValid(double val) {
            return val < this.bound;
        }

        @Override
        protected Stream<ValidationResult.ValidationError> toError(double val) {
            return Stream.of(new ValidationResult.ValidationError(this.pointer, val + " is strictly more than " + this.bound));
        }

        public String toString() {
            return "ExclusiveMaximum{factor=" + this.bound + ", pointer='" + this.pointer + "'}";
        }
    }
}

