/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.converter;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Converter;

public class EnumConverter<T extends Enum<T>>
implements Converter<T>,
Converter.TypeAccess {
    private final Map<String, T> values;
    private final Class<T> enumType;

    public EnumConverter(Class<T> aClass) {
        this.enumType = aClass;
        Enum[] enumConstants = (Enum[])aClass.getEnumConstants();
        this.values = new HashMap<String, T>(enumConstants.length);
        for (Enum t : enumConstants) {
            this.values.put(t.name(), t);
        }
    }

    @Override
    public String toString(T instance) {
        return ((Enum)instance).name();
    }

    @Override
    public T fromString(String text) {
        return (T)((Enum)this.values.get(text));
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.values.keySet();
    }

    @Override
    public Type type() {
        return this.enumType;
    }
}

