/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.runtime.TargetState;

public class CreateConnectorRequest {
    private final String name;
    private final Map<String, String> config;
    private final InitialState initialState;

    @JsonCreator
    public CreateConnectorRequest(@JsonProperty(value="name") String name, @JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="initial_state") InitialState initialState) {
        this.name = name;
        this.config = config;
        this.initialState = initialState;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Map<String, String> config() {
        return this.config;
    }

    @JsonProperty(value="initial_state")
    public InitialState initialState() {
        return this.initialState;
    }

    public TargetState initialTargetState() {
        if (this.initialState != null) {
            return this.initialState.toTargetState();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateConnectorRequest that = (CreateConnectorRequest)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.config, that.config) && Objects.equals((Object)this.initialState, (Object)that.initialState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.config, this.initialState});
    }

    public static enum InitialState {
        RUNNING,
        PAUSED,
        STOPPED;


        @JsonCreator
        public static InitialState forValue(String value) {
            return InitialState.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public TargetState toTargetState() {
            switch (this) {
                case RUNNING: {
                    return TargetState.STARTED;
                }
                case PAUSED: {
                    return TargetState.PAUSED;
                }
                case STOPPED: {
                    return TargetState.STOPPED;
                }
            }
            throw new IllegalArgumentException("Unknown initial state: " + (Object)((Object)this));
        }
    }
}

