/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.runtime.TransformationChain;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.tracing.Tracer;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Confluent
public class TracingTransformationChain<R extends ConnectRecord<R>>
extends TransformationChain<R> {
    private static final Logger log = LoggerFactory.getLogger(TracingTransformationChain.class);
    protected final Tracer tracer;
    protected final List<String> transformationNames;
    private Iterator<String> transformationNamesIterator;

    public TracingTransformationChain(Tracer tracer, RetryWithToleranceOperator retryWithToleranceOperator) {
        super(tracer.tracerConfig().connectorConfig().transformations(), retryWithToleranceOperator);
        this.transformationNames = tracer.tracerConfig().connectorConfig().getList("transforms");
        this.tracer = tracer;
    }

    @Override
    protected R transformRecord(R record, Transformation<R> transformation) {
        String transformationName = this.transformationNamesIterator.next();
        this.tracer.tracingContext().setCurrentTransformationName(transformationName);
        R transformedRecord = super.transformRecord(record, transformation);
        if (!super.hasFailed()) {
            this.tracer.traceRecordBuilder().appendTransformedRecord(this.tracer.tracingContext().currentTransformationName(), this.tracer.tracingContext().currentTransformationType(), transformedRecord, record);
        }
        return transformedRecord;
    }

    @Override
    public R apply(R record) {
        this.transformationNamesIterator = this.transformationNames.iterator();
        this.tracer.traceRecordBuilder().appendRecord(record);
        return super.apply(record);
    }
}

